/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import processing.core.PApplet;
import processing.core.PImage;

public class ControllerSprite {
    protected PImage sprite;
    protected PImage display;
    protected PImage mask;
    protected int offsetX;
    protected int offsetY;
    protected int width;
    protected int height;
    protected int wh;
    protected boolean isMask;
    protected int _myState;

    public ControllerSprite(ControlP5 controlP5, PImage pImage, int n, int n2) {
        this.sprite = pImage;
        this.width = n;
        this.height = n2;
        this.wh = this.width * this.height;
        this._myState = 0;
        this.display = new PImage(n, n2);
        this.display = ControlP5.papplet.createImage(n, n2, 1);
        this.update();
    }

    public void draw(PApplet pApplet) {
        pApplet.pushStyle();
        pApplet.imageMode(0);
        if (this.isMask) {
            this.display.mask(this.mask);
        }
        pApplet.image(this.display, 0.0f, 0.0f);
        pApplet.popStyle();
    }

    public void update() {
        this.display.loadPixels();
        System.arraycopy(this.sprite.pixels, this.wh * this._myState, this.display.pixels, 0, this.wh);
        this.display.updatePixels();
    }

    public void setOffset(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
        this.update();
    }

    public void setState(int n) {
        if (n != this._myState) {
            this._myState = n;
            this.offsetY = this.height * this._myState;
            this.update();
        }
    }

    public int getState() {
        return this._myState;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void setMask(PImage pImage) {
        this.mask = pImage;
    }

    public void enableMask() {
        this.isMask = true;
    }

    public void disableMask() {
        this.isMask = true;
    }
}

