/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.Toggle;
import java.util.Vector;

public class RadioButton
extends ControlGroup {
    Vector _myRadioToggles;
    protected int rowSpacing = 2;
    protected int columnSpacing = 2;
    protected int itemsPerRow = -1;
    protected boolean isMultipleChoice;

    public RadioButton(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2) {
        super(controlP5, controllerGroup, string, n, n2, 100, 9);
        this.isBarVisible = false;
        this.isBarToggle = false;
        this._myRadioToggles = new Vector();
        this.setItemsPerRow(1);
    }

    public Toggle addItem(String string, float f) {
        Toggle toggle = this.controlP5.addToggle(string, 0.0f, 0.0f, 11, 11);
        toggle.captionLabel().style().marginLeft = toggle.width + 4;
        toggle.captionLabel().style().marginTop = -toggle.height - 2;
        return this.addItem(toggle, f);
    }

    public Toggle addItem(Toggle toggle, float f) {
        toggle.setGroup(this);
        toggle.isMoveable = false;
        toggle.setInternalValue(f);
        toggle.isBroadcast = false;
        this._myRadioToggles.add(toggle);
        this.updateLayout();
        this.color().copyTo(toggle);
        toggle.addListener(this);
        this.updateValues(false);
        return toggle;
    }

    public void removeItem(String string) {
        for (int i = 0; i < this._myRadioToggles.size(); ++i) {
            if (!((Toggle)this._myRadioToggles.get(i)).name().equals(string)) continue;
            ((Toggle)this._myRadioToggles.get(i)).removeListener(this);
            this._myRadioToggles.remove(i);
        }
        this.updateValues(false);
    }

    public Toggle getItem(int n) {
        return (Toggle)this._myRadioToggles.get(n);
    }

    public void updateLayout() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this._myRadioToggles.size(); ++i) {
            Toggle toggle = (Toggle)this._myRadioToggles.get(i);
            toggle.position().y = n3;
            toggle.position().x = n2;
            n2 += toggle.width + this.columnSpacing;
            if (++n == this.itemsPerRow) {
                n = 0;
                this._myWidth = n2;
                n3 += toggle.height + this.rowSpacing;
                n2 = 0;
                continue;
            }
            this._myWidth = n2;
        }
    }

    public void setItemsPerRow(int n) {
        this.itemsPerRow = n;
        this.updateLayout();
    }

    public void setSpacingColumn(int n) {
        this.columnSpacing = n;
        this.updateLayout();
    }

    public void setSpacingRow(int n) {
        this.rowSpacing = n;
        this.updateLayout();
    }

    public void deactivateAll() {
        for (int i = 0; i < this._myRadioToggles.size(); ++i) {
            ((Toggle)this._myRadioToggles.get(i)).deactivate();
        }
        this._myValue = -1.0f;
        this.updateValues(true);
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (!this.isMultipleChoice) {
            this._myValue = -1.0f;
            for (int i = 0; i < this._myRadioToggles.size(); ++i) {
                if (!((Toggle)this._myRadioToggles.get(i)).equals(controlEvent.controller())) {
                    ((Toggle)this._myRadioToggles.get(i)).deactivate();
                    continue;
                }
                if (!((Toggle)this._myRadioToggles.get((int)i)).isOn) continue;
                this._myValue = ((Toggle)this._myRadioToggles.get(i)).internalValue();
            }
        }
        this.updateValues(true);
    }

    protected void updateValues(boolean bl) {
        this._myArrayValue = new float[this._myRadioToggles.size()];
        for (int i = 0; i < this._myRadioToggles.size(); ++i) {
            this._myArrayValue[i] = ((Toggle)this._myRadioToggles.get(i)).value();
        }
        if (bl) {
            ControlEvent controlEvent = new ControlEvent(this);
            this.controlP5.controlbroadcaster().broadcast(controlEvent, 1);
        }
    }
}

