/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.ControllerGroup;
import controlP5.Slider;
import java.util.Vector;
import processing.core.PApplet;

public class ListBox
extends ControlGroup
implements ControlListener {
    protected int _myAdjustedListHeight;
    protected int _myItemHeight = 13;
    protected Slider _myScrollbar;
    protected String _myName;
    protected float _myScrollValue = 0.0f;
    protected boolean isScrollbarVisible = true;
    protected int _myHeight;
    protected Vector items;
    protected int spacing;
    protected boolean isMultipleChoice = false;

    protected ListBox(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, 9);
        this._myWidth = n3;
        this._myBackgroundHeight = n4;
        this.items = new Vector();
        this._myAdjustedListHeight = this._myBackgroundHeight / this._myItemHeight * this._myItemHeight + 1 - 2;
        this._myScrollbar = new Slider(this.controlP5, this._myParent, string + "Scroller", 0.0f, 1.0f, 1.0f, this._myWidth + 1, 0, 10, this._myAdjustedListHeight);
        this._myName = string;
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.setMoveable(false);
        this._myScrollbar.setLabelVisible(false);
        this._myScrollbar.setParent(this);
        this.add(this._myScrollbar);
        this._myScrollbar.addListener(this);
        this._myScrollbar.setVisible(false);
        this._myScrollbar.hide();
    }

    public void hideScrollbar() {
        this.isScrollbarVisible = false;
        this._myScrollbar.hide();
    }

    public void showScrollbar() {
        this.isScrollbarVisible = true;
        if ((this.controllers.size() - 1) * this._myItemHeight > this._myAdjustedListHeight && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
    }

    public boolean isScrollbarVisible() {
        return this.isScrollbarVisible;
    }

    public void scroll(float f) {
        if (this.items.size() * this._myItemHeight > this._myAdjustedListHeight) {
            this._myScrollbar.setValue(PApplet.abs((float)(1.0f - PApplet.min((float)PApplet.max((float)0.0f, (float)f), (float)1.0f))));
        }
    }

    private void scroll() {
        int n = 0;
        if (this.items.size() * this._myItemHeight > this._myAdjustedListHeight && this.isScrollbarVisible) {
            this._myScrollbar.show();
            n = (int)(this._myScrollValue * (float)(this.items.size() * this._myItemHeight - this._myAdjustedListHeight) / (float)this._myItemHeight) * this._myItemHeight;
            for (int i = 1; i < this.controllers.size(); ++i) {
                int n2 = Math.abs(n / this._myItemHeight) + (i - 1);
                n2 = Math.max(0, Math.min(n2, this.items.size() - 1));
                ((Button)this.controllers.get(i)).captionLabel().set(((ListBoxItem)this.items.get((int)n2)).text);
                ((Button)this.controllers.get((int)i))._myValue = ((ListBoxItem)this.items.get((int)n2)).value;
            }
        } else {
            this._myScrollbar.hide();
            for (int i = 1; i < this.controllers.size(); ++i) {
                int n3 = i - 1;
                ((Button)this.controllers.get(i)).captionLabel().set(((ListBoxItem)this.items.get((int)n3)).text);
                ((Button)this.controllers.get((int)i))._myValue = ((ListBoxItem)this.items.get((int)n3)).value;
            }
        }
    }

    public void setItemHeight(int n) {
        this._myItemHeight = n;
        this._myAdjustedListHeight = this._myBackgroundHeight / this._myItemHeight * this._myItemHeight + this.spacing - 2;
        this._myScrollbar.setHeight(this._myAdjustedListHeight + 1);
        for (int i = 1; i < this.controllers.size(); ++i) {
            ((Button)this.controllers.get((int)i)).height = n - 1;
            ((Button)this.controllers.get((int)i)).position.y = (n + this.spacing) * (i - 1);
        }
        this.setHeight(this._myBackgroundHeight);
    }

    public void setHeight(int n) {
        int n2;
        boolean bl;
        this._myBackgroundHeight = n;
        this._myAdjustedListHeight = this._myBackgroundHeight / this._myItemHeight * this._myItemHeight + this.spacing - 2;
        int n3 = this.controllers.size() - 1;
        int n4 = this._myBackgroundHeight / this._myItemHeight;
        boolean bl2 = bl = this._myBackgroundHeight < (this._myItemHeight + this.spacing) * this.items.size();
        if (n3 > n4) {
            for (n2 = 0; n2 < n3 - n4; ++n2) {
                String string = this._myName + "Button" + (n4 + n2);
                this.controllers.remove(this.controlP5.controller(string));
                this.controlP5.remove(string);
            }
            if (bl) {
                this._myScrollbar.show();
                this.scroll();
            } else {
                this._myScrollbar.hide();
            }
        }
        if (n3 < n4) {
            n2 = Math.min(n4, this.items.size());
            this.addListButton(n2 -= n3);
            if (bl) {
                this._myScrollbar.show();
                this.scroll();
            } else {
                this._myScrollbar.hide();
            }
        }
        this._myScrollbar.setHeight(this._myAdjustedListHeight + 1);
        this.scroll();
    }

    public void setWidth(int n) {
        this._myWidth = n;
        for (int i = 1; i < this.controllers.size(); ++i) {
            ((Button)this.controllers.get((int)i)).width = n;
        }
        this._myScrollbar.position.x = this._myWidth + 1;
    }

    protected void addListButton(int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = this.controllers.size() - 1;
            if (n2 * this._myItemHeight >= this._myBackgroundHeight) continue;
            Button button = new Button(this.controlP5, this, this._myName + "Button" + n2, n2, 0, n2 * this._myItemHeight, this._myWidth, this._myItemHeight - 1, false);
            button.setMoveable(false);
            this.add(button);
            this.controlP5.register(button);
            button.setBroadcast(false);
            button.addListener(this);
        }
        this.updateScroll();
    }

    private void updateScroll() {
        this._myScrollValue = this._myScrollbar.value();
        this._myScrollbar.setValue(this._myScrollValue);
        if ((this.items.size() - 1) * this._myItemHeight > this._myAdjustedListHeight && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
        this.scroll();
    }

    public void addItem(String string, int n) {
        this.items.add(new ListBoxItem(string, n));
        this.addListButton(1);
    }

    public void removeItem(String string) {
        block4: {
            try {
                for (int i = this.items.size() - 1; i >= 0; --i) {
                    if (!((ListBoxItem)this.items.get((int)i)).name.equals(string)) continue;
                    this.items.remove(i);
                }
                if (this.controllers.size() - 1 > this.items.size()) {
                    String string2 = ((Button)this.controllers.get(this.controllers.size() - 1)).name();
                    this.controllers.remove(this.controlP5.controller(string2));
                    this.controlP5.remove(string2);
                }
                this.updateScroll();
            }
            catch (Exception exception) {
                if (!ControlP5.DEBUG) break block4;
                System.out.println("ScrollList.removeItem exception:" + exception);
            }
        }
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.controller() instanceof Button) {
            try {
                this._myValue = controlEvent.controller().value();
                ControlEvent controlEvent2 = new ControlEvent(this);
                this.controlP5.controlbroadcaster().broadcast(controlEvent2, 1);
            }
            catch (Exception exception) {}
        } else {
            this._myScrollValue = -(1.0f - controlEvent.value());
            this.scroll();
        }
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "listBox");
    }

    class ListBoxItem {
        String name;
        String text;
        int value;
        boolean isActive;

        ListBoxItem(String string, int n) {
            this.name = string;
            this.text = string;
            this.value = n;
        }
    }
}

