/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.Label;
import controlP5.Tab;
import processing.core.PApplet;

public class Numberbox
extends Controller {
    protected int cnt;
    protected boolean isActive;
    public static int LEFT = 0;
    public static int UP = 1;
    public static int RIGHT = 2;
    public static int DOWN = 3;
    protected int _myNumberCount = UP;
    protected float _myMultiplier = 1.0f;

    public Numberbox(ControlP5 controlP5, Tab tab, String string, float f, int n, int n2, int n3, int n4) {
        super(controlP5, tab, string, n, n2, n3, n4);
        this._myValue = f;
        this._myValueLabel = new Label("" + this._myValue, n3, 12, this.color.colorValue);
        this._myMin = -1000000.0f;
        this._myMax = 1000000.0f;
    }

    public void updateInternalEvents(PApplet pApplet) {
        if (this.isActive && !ControlP5.keyHandler.isAltDown) {
            this.setValue(this._myValue + (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY) * this._myMultiplier);
        }
    }

    public void draw(PApplet pApplet) {
        pApplet.pushMatrix();
        pApplet.translate(this.position().x(), this.position().y());
        pApplet.stroke(this.color.colorForeground);
        pApplet.fill(this.color.colorBackground);
        pApplet.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
        pApplet.noStroke();
        this._myCaptionLabel.draw(pApplet, 4, this.height + 4);
        this._myValueLabel.draw(pApplet, 4, 4);
        pApplet.popMatrix();
    }

    public void mousePressed() {
        this.isActive = true;
    }

    public void mouseReleased() {
        this.isActive = false;
    }

    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public void setMultiplier(float f) {
        this._myMultiplier = f;
    }

    public float multiplier() {
        return this._myMultiplier;
    }

    public void setValue(float f) {
        this._myValue = f;
        this._myValue = Math.max(this._myMin, Math.min(this._myMax, this._myValue));
        this.broadcast(1);
        this._myValueLabel.set(this.adjustValue(this._myValue));
    }

    public void setDirection(int n) {
        if (n >= 0 && n <= DOWN) {
            this._myNumberCount = n;
        }
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "numberbox");
    }
}

