/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.Label;
import processing.core.PApplet;

public class Slider
extends Controller {
    protected static final int HORIZONTAL = 0;
    protected static final int VERTICAL = 1;
    private int _myDirection;
    public static final int FIX = 1;
    public static final int FLEXIBLE = 0;
    protected int _mySliderMode = 1;
    protected float _myValuePosition;
    protected float _mySliderbarSize = 0.0f;
    protected int steps = -1;

    public Slider(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, float f3, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myCaptionLabel = new Label(string, this.color.colorLabel);
        this._myMin = f;
        this._myMax = f2;
        this._myValueLabel = new Label("" + (this.adjustValue(this._myMax).length() > this.adjustValue(this._myMin).length() ? this.adjustValue(this._myMax) : this.adjustValue(this._myMin)), this.color.colorValue);
        this._myValueLabel.set("" + this.adjustValue(this._myValue));
        this._myValue = f3;
        this.setSliderMode(1);
        this._myDirection = this.width > this.height ? 0 : 1;
        this.valueLabel();
    }

    public void setSliderMode(int n) {
        this._mySliderMode = n;
        this._mySliderbarSize = this._mySliderMode == 0 ? 10.0f : 0.0f;
        this._myUnit = (this._myMax - this._myMin) / (this.width > this.height ? (float)this.width - this._mySliderbarSize : (float)this.height - this._mySliderbarSize);
        this.setValue(this._myValue);
    }

    public void updateInternalEvents(PApplet pApplet) {
        if (this.isVisible && this.isMousePressed && !ControlP5.keyHandler.isAltDown) {
            if (this._myDirection == 0) {
                this.setValue(this._myMin + ((float)this._myControlWindow.mouseX - (this._myParent.absolutePosition().x() + this.position.x)) * this._myUnit);
            } else {
                this.setValue(this._myMin + -((float)this._myControlWindow.mouseY - (this._myParent.absolutePosition().y() + this.position.y) - (float)this.height) * this._myUnit);
            }
        }
    }

    public void draw(PApplet pApplet) {
        if (this.isVisible) {
            pApplet.pushMatrix();
            pApplet.translate(this.position().x(), this.position().y());
            pApplet.fill(this.color.colorBackground);
            pApplet.noStroke();
            pApplet.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
            pApplet.fill(this.isInside ? this.color.colorActive : this.color.colorForeground);
            if (this._myDirection == 0) {
                if (this._mySliderMode == 1) {
                    pApplet.rect(0.0f, 0.0f, this._myValuePosition, (float)this.height);
                } else {
                    pApplet.rect(this._myValuePosition, 0.0f, this._mySliderbarSize, (float)this.height);
                }
            } else if (this._mySliderMode == 1) {
                pApplet.rect(0.0f, (float)this.height, (float)this.width, -this._myValuePosition);
            } else {
                pApplet.rect(0.0f, (float)this.height - this._myValuePosition - this._mySliderbarSize, (float)this.width, this._mySliderbarSize);
            }
            if (this.isLabelVisible) {
                if (this._myDirection == 0) {
                    this._myCaptionLabel.draw(pApplet, this.width + 3, this.height / 2 - 3);
                    this._myValueLabel.draw(pApplet, 3, this.height / 2 - 3);
                } else {
                    this._myCaptionLabel.draw(pApplet, 0, this.height + 3);
                    this._myValueLabel.draw(pApplet, this.width + 4, -((int)this._myValuePosition) + this.height - 8);
                }
            }
            pApplet.popMatrix();
        }
    }

    public void setValue(float f) {
        this._myValue = f;
        this._myValue = this._myValue <= this._myMin ? this._myMin : this._myValue;
        this._myValue = this._myValue >= this._myMax ? this._myMax : this._myValue;
        this._myValuePosition = (this._myValue - this._myMin) / this._myUnit;
        this._myValueLabel.set(this.adjustValue(this._myValue));
        this.broadcast(1);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void setMin(float f) {
        this._myMin = f;
        this.setSliderMode(this._mySliderMode);
    }

    public void setMax(float f) {
        this._myMax = f;
        this.setSliderMode(this._mySliderMode);
    }

    public Controller setWidth(int n) {
        this.width = n;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    public Controller setHeight(int n) {
        this.height = n;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "slider");
        controlP5XMLElement.setAttribute("min", new Float(this.min()));
        controlP5XMLElement.setAttribute("max", new Float(this.max()));
    }
}

