int points = 5000; //points in each frame
//float fcut = 0.5;
float fmax = 0.1;
float xsize,ysize,zsize,rsize;


//////////////////////////////
/// --- PAINT MC POINTS --- //
//////////////////////////////

void gencloud(int points){

  int genpts=0;
  for (int i =0;i<points;i++){
    float fx=random(xDown+0.01,xUp-1.01);
    float fy=random(yDown+0.01,yUp-1.01);
    float fz=random(zDown+0.01,zUp-1.01);
    float f = inter(fx,fy,fz);
    //float f = xyz[int(fx)][int(fy)][int(fz)];
    
    fx/=(xs-1);
    fy/=(ys-1);
    fz/=(zs-1);

    float x = fx*abc[0][0]+fy*abc[1][0]+fz*abc[2][0];
    float y = fx*abc[0][1]+fy*abc[1][1]+fz*abc[2][1];
    float z = fx*abc[0][2]+fy*abc[1][2]+fz*abc[2][2];

    x-=xsize*0.5;
    y-=ysize*0.5;
    z-=zsize*0.5;
   
   // OPAQUE COLOR(VAL)
   //if(abs(f)<fcut){
   if((f>0)&&(positive)){
      stroke(0,0,255*f/fmax,255);
      point(x*zoom,y*zoom,z*zoom);
      genpts++;
    }else if(negative){
      stroke(-255*f/fmax,0,0,-255);
      point(x*zoom,y*zoom,z*zoom);
      genpts++;
    }
   //}
   
    /*
    //PROBABILITY(VAL) ALPHA=OPACITY
    if(f>random(0,fmax)){
      stroke(0,0,255,opacity);
      point(x*zoom,y*zoom,z*zoom);
      genpts++;
    }else if(-f>random(0,fmax)){
      stroke(255,0,0,opacity);
      point(x*zoom,y*zoom,z*zoom);
      genpts++;
    }

    // ALPHA(VAL)
    if(f>0){
      stroke(0,0,255,255*f/fmax);
      point(x*zoom,y*zoom,z*zoom);
      genpts++;
    }else{
      stroke(255,0,0,-255*f/fmax);
      point(x*zoom,y*zoom,z*zoom);
      genpts++;
    }  
   */
  }
  //println("MotneCarlo generated "+genpts+" points of "+points+" trials ");
}


/////////////////////////////////////////
/// --- INTERPOLATED FUCTION POINT --- //
////////////////////////////////////////


float inter(float fx,float fy,float fz){
  int x=0;
  int y=0;
  int z=0;
  while(x<=fx){ x++; }
  while(y<=fy){ y++; }
  while(z<=fz){ z++; }
  fx-=(x-1);
  fy-=(y-1);
  fz-=(z-1);
  
  float val =
    xyz[x-1][y-1][z-1]*(1-fx)*(1-fy)*(1-fz)+
    xyz[x-1][y-1][z  ]*(1-fx)*(1-fy)*   fz +
    xyz[x-1][y  ][z-1]*(1-fx)*   fy *(1-fz)+
    xyz[x-1][y  ][z  ]*(1-fx)*   fy *   fz +
    xyz[x  ][y-1][z-1]*   fx *(1-fy)*(1-fz)+
    xyz[x  ][y-1][z  ]*   fx *(1-fy)*   fz +
    xyz[x  ][y  ][z-1]*   fx *   fy *(1-fz)+
    xyz[x  ][y  ][z  ]*   fx *   fy *   fz ;
   
    /*
    float val =
    xyz[x-1][y-1][z-1]*    fx*    fy*   fz+
    xyz[x-1][y-1][z  ]*    fx*    fy*(1-fz)+
    xyz[x-1][y  ][z-1]*    fx*(1-fy)*   fz +
    xyz[x-1][y  ][z  ]*    fx*(1-fy)*(1-fz)+
    xyz[x  ][y-1][z-1]*(1-fx)*    fy*   fz +
    xyz[x  ][y-1][z  ]*(1-fx)*    fy*(1-fz)+
    xyz[x  ][y  ][z-1]*(1-fx)*(1-fy)*   fz +
    xyz[x  ][y  ][z  ]*(1-fx)*(1-fy)*(1-fz);
   */
  return(val);
};
