/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.Label;
import processing.core.PApplet;

public class Range
extends Controller {
    protected static final int HORIZONTAL = 0;
    protected static final int VERTICAL = 1;
    protected int _myDirection;
    public static final int FIX = 1;
    public static final int FLEXIBLE = 0;
    protected int _mySliderMode = 1;
    protected float _myValuePosition;
    protected boolean isDragging;
    protected boolean isDraggable = true;
    protected boolean isFirstClick;
    protected Label _myHighValueLabel;
    protected float _myValueRange;
    protected boolean isMinHandle;
    protected boolean isMaxHandle;
    protected boolean isMoveHandle;
    protected float distanceHandle;
    protected int handleSize = 10;
    protected float minHandle = 0.0f;
    protected float maxHandle = 0.0f;

    public Range(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myCaptionLabel = new Label(string, this.color.colorLabel);
        this._myArrayValue = new float[]{f3, f4};
        this._myMin = f;
        this._myMax = f2;
        this._myValueRange = this._myMax - this._myMin;
        this.minHandle = f3 / this._myValueRange * (float)this.width;
        this.maxHandle = f4 / this._myValueRange * (float)this.width;
        this._myValueLabel = new Label("" + this.adjustValue(this._myMin), this.color.colorValue);
        this._myValueLabel.set("" + this.adjustValue(f3));
        this._myHighValueLabel = new Label(this.adjustValue(this._myMax), this.color.colorValue);
        this._myHighValueLabel.set("" + this.adjustValue(f4));
        this._myValue = f3;
        this.setSliderMode(1);
        this._myDirection = 0;
        this.update();
    }

    public void setSliderMode(int n) {
    }

    public void updateInternalEvents(PApplet pApplet) {
        if (this.isVisible) {
            float f;
            float f2;
            float f3 = (float)this._myControlWindow.mouseX - this.absolutePosition().x();
            if (!this.isMousePressed && this.isInside) {
                f2 = this.minHandle + (float)this.handleSize;
                f = this.maxHandle + (float)this.handleSize;
                this.isMinHandle = f3 > this.minHandle && f3 < f2;
                boolean bl = this.isMaxHandle = f3 > this.maxHandle && f3 < f;
            }
            if (this.isMousePressed && !ControlP5.keyHandler.isAltDown && (this._myControlWindow.mouseX != this._myControlWindow.pmouseX || this._myControlWindow.mouseY != this._myControlWindow.pmouseY)) {
                f2 = this.minHandle + (float)this.handleSize;
                f = this.maxHandle + (float)this.handleSize;
                if (!this.isDragging) {
                    this.isMinHandle = f3 > this.minHandle && f3 < f2;
                    boolean bl = this.isMaxHandle = f3 > this.maxHandle && f3 < f;
                    this.isMoveHandle = this.isDraggable ? f3 > f2 && f3 < this.maxHandle : false;
                    boolean bl2 = this.isDragging = this.isMinHandle || this.isMaxHandle || this.isMoveHandle;
                }
                if (this.isDragging) {
                    float f4 = this._myControlWindow.mouseX - this._myControlWindow.pmouseX;
                    if (this.isMinHandle) {
                        this.minHandle += f4;
                        this.minHandle = PApplet.constrain((float)this.minHandle, (float)0.0f, (float)(this.maxHandle - (float)this.handleSize));
                        this.setLowValue(this._myMin + this.minHandle / (float)(this.width - this.handleSize * 2) * this._myValueRange);
                    } else if (this.isMaxHandle) {
                        this.maxHandle += f4;
                        this.maxHandle = PApplet.constrain((float)this.maxHandle, (float)f2, (float)(this.width - this.handleSize));
                        this.setHighValue(this._myMin + (this.maxHandle - (float)this.handleSize) / (float)(this.width - this.handleSize * 2) * this._myValueRange);
                    } else if (this.isMoveHandle) {
                        float f5 = f4 * (this._myValueRange / (float)this.width);
                        if (this._myArrayValue[0] + f5 >= this._myMin && this._myArrayValue[1] + f5 <= this._myMax) {
                            this._myArrayValue[0] = this._myArrayValue[0] + f5;
                            this._myArrayValue[1] = this._myArrayValue[1] + f5;
                        }
                        this.update();
                    }
                }
            }
        }
    }

    public void draw(PApplet pApplet) {
        if (this.isVisible) {
            pApplet.pushMatrix();
            pApplet.translate(this.position().x(), this.position().y());
            pApplet.fill(this.color.colorBackground);
            pApplet.noStroke();
            pApplet.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
            pApplet.fill(this.color.colorForeground);
            pApplet.rect(this.minHandle, 0.0f, this.maxHandle - this.minHandle, (float)this.height);
            pApplet.fill(this.isMinHandle ? this.color.colorActive : this.color.colorForeground);
            pApplet.rect(this.minHandle, 0.0f, (float)this.handleSize, (float)this.height);
            pApplet.fill(this.isMaxHandle ? this.color.colorActive : this.color.colorForeground);
            pApplet.rect(this.maxHandle, 0.0f, (float)this.handleSize, (float)this.height);
            if (this.isLabelVisible) {
                this._myCaptionLabel.draw(pApplet, this.width + 3, this.height / 2 - 3);
                this._myValueLabel.draw(pApplet, 3, this.height / 2 - 3);
                this._myHighValueLabel.draw(pApplet, this.width - this._myHighValueLabel.width(), this.height / 2 - 3);
            } else {
                this._myCaptionLabel.draw(pApplet, 0, this.height + 3);
                this._myValueLabel.draw(pApplet, this.width + 4, -((int)this._myValuePosition) + this.height - 8);
            }
            pApplet.popMatrix();
        }
    }

    public void setValue(float f) {
        this._myValue = f;
        this.broadcast(4);
    }

    public void update() {
        this.minHandle = (this._myArrayValue[0] - this._myMin) / this._myValueRange * (float)(this.width - this.handleSize * 2);
        this.maxHandle = (float)(this.width - this.handleSize * 2) * ((this._myArrayValue[1] - this._myMin) / this._myValueRange) + (float)this.handleSize;
        this._myHighValueLabel.set(this.adjustValue(this._myArrayValue[1]));
        this._myValueLabel.set(this.adjustValue(this._myArrayValue[0]));
        this.setValue(this._myValue);
    }

    public void setDraggable(boolean bl) {
        this.isDraggable = bl;
        this.isDragging = !bl ? false : this.isDragging;
    }

    public float[] arrayValue() {
        return this._myArrayValue;
    }

    public void setMin(float f) {
        this._myMin = f;
        this.update();
    }

    public void setMax(float f) {
        this._myMax = f;
        this.update();
    }

    public float lowValue() {
        return this._myArrayValue[0];
    }

    public float highValue() {
        return this._myArrayValue[1];
    }

    public void setLowValue(float f) {
        this._myArrayValue[0] = f;
        this.update();
    }

    public void setHighValue(float f) {
        this._myArrayValue[1] = f;
        this.update();
    }

    public Controller setWidth(int n) {
        this.width = n;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    public Controller setHeight(int n) {
        this.height = n;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    public void mouseReleased() {
        this.isMoveHandle = false;
        this.isMaxHandle = false;
        this.isMinHandle = false;
        this.isDragging = false;
    }

    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public void onLeave() {
        this.isMinHandle = false;
        this.isMaxHandle = false;
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "range");
        controlP5XMLElement.setAttribute("min", new Float(this.min()));
        controlP5XMLElement.setAttribute("max", new Float(this.max()));
    }
}

