/*
 * Decompiled with CFR 0.152.
 */
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ControlWindow;
import controlP5.Range;
import controlP5.Textfield;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;

public class CloudView_15_fir2
extends PApplet {
    GL gl;
    float zoom = 50.0f;
    float zoff = 3000.0f;
    int opacity = 1;
    boolean positive = true;
    boolean negative = true;
    boolean paint = true;
    float ax = 0.0f;
    float ay = 0.0f;
    float xoff = 0.0f;
    float yoff = 0.0f;
    float mx_;
    float my_;
    float mxstart;
    float mystart;
    ControlP5 gui;
    ControlWindow guiW;
    Range rangeX;
    Range rangeY;
    Range rangeZ;
    Textfield fmaxField;
    boolean clear = false;
    float[][][] xyz;
    float[][] abc;
    int xs;
    int ys;
    int zs;
    int nums;
    int xUp;
    int yUp;
    int zUp;
    int xDown;
    int yDown;
    int zDown;
    int words = 5;
    atom[] geom;
    int atoms = 0;
    int points = 5000;
    float fmax = 0.1f;
    float xsize;
    float ysize;
    float zsize;
    float rsize;

    public void setup() {
        this.size(800, 800, "processing.opengl.PGraphicsOpenGL");
        this.frameRate(90.0f);
        this.ortho(-this.width, this.width, -this.height, this.height, 0.0f, 10000.0f);
        this.gl = ((PGraphicsOpenGL)this.g).gl;
        this.loadgeom_BOTH();
        this.load();
        this.camera(0.0f, 0.0f, -this.zoff, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.background(0);
        this.setupgui();
    }

    public void draw() {
        this.gui.draw();
        this.gl.glEnable(3042);
        this.gl.glDisable(3456);
        this.gl.glDisable(2903);
        this.gl.glDisable(2896);
        this.gl.glDisable(2884);
        this.gl.glDisable(2929);
        this.gl.glDisable(3008);
        this.gl.glBlendEquation(32776);
        this.gl.glBlendFunc(770, 0);
        this.gl.glTranslatef(this.xoff, this.yoff, 0.0f);
        this.gl.glTranslatef(0.0f, 0.0f, -this.zoff);
        this.gl.glRotatef(this.ax, 0.0f, 1.0f, 0.0f);
        this.gl.glRotatef(this.ay, -1.0f, 0.0f, 0.0f);
        this.gl.glTranslatef(0.0f, 0.0f, this.zoff);
        if (!this.mousePressed && this.paint) {
            this.gencloud(this.points);
        }
        this.gl.glBlendFunc(1, 0);
        this.strokeWeight(3.0f);
        this.stroke(128, 255.0f);
        int n = 0;
        while (n < this.atoms) {
            this.point((this.geom[n].x - this.xsize / 2.0f) * this.zoom, (this.geom[n].y - this.ysize / 2.0f) * this.zoom, (this.geom[n].z - this.zsize / 2.0f) * this.zoom);
            ++n;
        }
        this.strokeWeight(1.0f);
        if (this.clear) {
            this.background(0);
            this.clear = false;
        }
    }

    public void mousePressed() {
        this.background(0);
        if (this.mouseButton == 37) {
            this.mxstart = this.mouseX;
            this.mystart = this.mouseY;
            this.mx_ = this.ax;
            this.my_ = this.ay;
        }
        if (this.mouseButton == 39) {
            this.mxstart = this.mouseX;
            this.mystart = this.mouseY;
            this.mx_ = this.xoff;
            this.my_ = this.yoff;
        }
    }

    public void mouseDragged() {
        this.background(0);
        if (this.mouseButton == 37) {
            this.ax = this.mx_ + (float)this.mouseX - this.mxstart;
            this.ay = this.my_ + (float)this.mouseY - this.mystart;
        }
        if (this.mouseButton == 39) {
            this.xoff = this.mx_ + (float)this.mouseX - this.mxstart;
            this.yoff = this.my_ + (float)this.mouseY - this.mystart;
        }
    }

    public void keyPressed() {
        if (this.key == 'i') {
            this.save(String.valueOf(CloudView_15_fir2.year()) + "-" + CloudView_15_fir2.month() + "-" + CloudView_15_fir2.day() + "-" + CloudView_15_fir2.minute() + "-" + CloudView_15_fir2.second());
        }
        if (this.key == '+') {
            this.zoom *= 1.618034f;
            this.gencloud(this.points);
            this.background(0);
        }
        if (this.key == '-') {
            this.zoom /= 1.618034f;
            this.gencloud(this.points);
            this.background(0);
        }
        if (this.key == 'a') {
            boolean bl = this.positive = !this.positive;
        }
        if (this.key == 's') {
            boolean bl = this.negative = !this.negative;
        }
        if (this.key == ' ') {
            this.paint = !this.paint;
        }
    }

    public void setupgui() {
        this.gui = new ControlP5((PApplet)this);
        this.gui.setAutoDraw(false);
        this.guiW = this.gui.addControlWindow("controlP5window", 0, 800, 800, 100);
        this.rangeX = this.gui.addRange(" X RANGE ", 0.0f, (float)this.xs, 0.0f, (float)this.xs, 10, 20, 400, 20);
        this.rangeX.setWindow(this.guiW);
        this.rangeY = this.gui.addRange(" Y RANGE ", 0.0f, (float)this.ys, 0.0f, (float)this.ys, 10, 40, 400, 20);
        this.rangeY.setWindow(this.guiW);
        this.rangeZ = this.gui.addRange(" Z RANGE ", 0.0f, (float)this.zs, 0.0f, (float)this.zs, 10, 60, 400, 20);
        this.rangeZ.setWindow(this.guiW);
        this.fmaxField = this.gui.addTextfield("f_max", 500, 20, 100, 20);
        this.fmaxField.setText("" + this.fmax);
        this.fmaxField.setAutoClear(false);
        this.fmaxField.setWindow(this.guiW);
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.controller() == this.rangeX) {
            this.xDown = PApplet.parseInt((float)controlEvent.controller().arrayValue()[0]);
            this.xUp = PApplet.parseInt((float)controlEvent.controller().arrayValue()[1]);
        }
        if (controlEvent.controller() == this.rangeY) {
            this.yDown = PApplet.parseInt((float)controlEvent.controller().arrayValue()[0]);
            this.yUp = PApplet.parseInt((float)controlEvent.controller().arrayValue()[1]);
        }
        if (controlEvent.controller() == this.rangeZ) {
            this.zDown = PApplet.parseInt((float)controlEvent.controller().arrayValue()[0]);
            this.zUp = PApplet.parseInt((float)controlEvent.controller().arrayValue()[1]);
        }
        if (controlEvent.controller() == this.fmaxField) {
            this.fmax = PApplet.parseFloat((String)controlEvent.controller().stringValue());
        }
        this.clear = true;
    }

    public void load() {
        int n;
        this.abc = new float[3][3];
        String[] stringArray = this.loadStrings("grid.xsf");
        String[] stringArray2 = null;
        int n2 = 0;
        while (stringArray2 == null) {
            stringArray2 = CloudView_15_fir2.match((String)stringArray[n2], (String)"DATAGRID_3D_");
            ++n2;
        }
        String[] stringArray3 = CloudView_15_fir2.splitTokens((String)stringArray[n2], (String)" \t");
        this.xs = PApplet.parseInt((String)stringArray3[0]);
        this.ys = PApplet.parseInt((String)stringArray3[1]);
        this.zs = PApplet.parseInt((String)stringArray3[2]);
        this.nums = this.xs * this.ys * this.zs;
        n2 += 2;
        this.xyz = new float[this.xs][this.ys][this.zs];
        int n3 = 0;
        while (n3 < 3) {
            stringArray3 = CloudView_15_fir2.splitTokens((String)stringArray[n2 + n3], (String)" \t");
            int n4 = 0;
            while (n4 < 3) {
                this.abc[n3][n4] = PApplet.parseFloat((String)stringArray3[n4]);
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < 3) {
            String string = "";
            n = 0;
            while (n < 3) {
                string = String.valueOf(string) + "\t" + this.abc[n3][n];
                ++n;
            }
            CloudView_15_fir2.println((String)string);
            ++n3;
        }
        CloudView_15_fir2.print((String)(String.valueOf(stringArray[n2 += 3].length()) + ": "));
        if (stringArray[n2].length() != 0) {
            this.words = 1;
            --n2;
            CloudView_15_fir2.println((String)"fireball");
        } else {
            CloudView_15_fir2.println((String)"vasp");
        }
        ++n2;
        n3 = this.nums / this.words;
        int n5 = 0;
        n = 0;
        while (n < n3) {
            stringArray3 = CloudView_15_fir2.splitTokens((String)stringArray[n2 + n], (String)" \t");
            int n6 = 0;
            while (n6 < this.words) {
                int n7 = n5 % this.xs;
                int n8 = n5 / this.xs % this.ys;
                int n9 = n5 / (this.xs * this.ys);
                this.xyz[n7][n8][n9] = PApplet.parseFloat((String)stringArray3[n6]);
                ++n5;
                ++n6;
            }
            ++n;
        }
        CloudView_15_fir2.println((String)("Grid of size " + this.xs + " x " + this.ys + " x " + this.zs + " = " + this.nums + " datapoints loaded"));
        this.xsize = CloudView_15_fir2.sqrt((float)(CloudView_15_fir2.sq((float)this.abc[0][0]) + CloudView_15_fir2.sq((float)this.abc[1][0]) + CloudView_15_fir2.sq((float)this.abc[2][0])));
        this.ysize = CloudView_15_fir2.sqrt((float)(CloudView_15_fir2.sq((float)this.abc[0][1]) + CloudView_15_fir2.sq((float)this.abc[1][1]) + CloudView_15_fir2.sq((float)this.abc[2][1])));
        this.zsize = CloudView_15_fir2.sqrt((float)(CloudView_15_fir2.sq((float)this.abc[0][2]) + CloudView_15_fir2.sq((float)this.abc[1][2]) + CloudView_15_fir2.sq((float)this.abc[2][2])));
        this.rsize = CloudView_15_fir2.sqrt((float)(CloudView_15_fir2.sq((float)this.xsize) + CloudView_15_fir2.sq((float)this.ysize) + CloudView_15_fir2.sq((float)this.zsize)));
        CloudView_15_fir2.println((String)("Cell size " + this.xsize + " x " + this.ysize + " x " + this.zsize + " | " + this.rsize + " "));
        this.xUp = this.xs;
        this.yUp = this.ys;
        this.zUp = this.zs;
        this.xDown = 0;
        this.yDown = 0;
        this.zDown = 0;
    }

    public void loadgeom() {
        String[] stringArray = this.loadStrings("grid.xsf");
        String[] stringArray2 = null;
        int n = 0;
        while (stringArray2 == null) {
            stringArray2 = CloudView_15_fir2.match((String)stringArray[n], (String)"PRIMCOORD");
            ++n;
        }
        String[] stringArray3 = CloudView_15_fir2.splitTokens((String)stringArray[n], (String)" \t");
        this.atoms = PApplet.parseInt((String)stringArray3[0]);
        this.geom = new atom[this.atoms];
        ++n;
        int n2 = 0;
        while (n2 < this.atoms) {
            this.geom[n2] = new atom();
            stringArray3 = CloudView_15_fir2.splitTokens((String)stringArray[n + n2], (String)" \t");
            this.geom[n2].element = PApplet.parseInt((String)stringArray3[0]);
            this.geom[n2].x = PApplet.parseFloat((String)stringArray3[1]);
            this.geom[n2].y = PApplet.parseFloat((String)stringArray3[2]);
            this.geom[n2].z = PApplet.parseFloat((String)stringArray3[3]);
            ++n2;
        }
    }

    public void loadgeom_ATOMS() {
        String[] stringArray = this.loadStrings("grid.xsf");
        String[] stringArray2 = null;
        int n = 0;
        while (stringArray2 == null) {
            stringArray2 = CloudView_15_fir2.match((String)stringArray[n], (String)"ATOMS");
            ++n;
        }
        int n2 = n;
        this.atoms = 0;
        while (stringArray[n].length() > 6) {
            ++n;
            ++this.atoms;
        }
        CloudView_15_fir2.println((int)this.atoms);
        this.geom = new atom[this.atoms];
        n = n2;
        int n3 = 0;
        while (n3 < this.atoms) {
            CloudView_15_fir2.println((int)n3);
            this.geom[n3] = new atom();
            String[] stringArray3 = CloudView_15_fir2.splitTokens((String)stringArray[n + n3], (String)" \t");
            this.geom[n3].element = PApplet.parseInt((String)stringArray3[0]);
            this.geom[n3].x = PApplet.parseFloat((String)stringArray3[1]);
            this.geom[n3].y = PApplet.parseFloat((String)stringArray3[2]);
            this.geom[n3].z = PApplet.parseFloat((String)stringArray3[3]);
            ++n3;
        }
    }

    public void loadgeom_BOTH() {
        int n;
        String[] stringArray;
        String[] stringArray2 = this.loadStrings("grid.xsf");
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        int n2 = 0;
        while (stringArray3 == null && stringArray4 == null) {
            stringArray3 = CloudView_15_fir2.match((String)stringArray2[n2], (String)"ATOMS");
            stringArray4 = CloudView_15_fir2.match((String)stringArray2[n2], (String)"PRIMCOORD");
            ++n2;
        }
        if (stringArray3 == null) {
            stringArray = CloudView_15_fir2.splitTokens((String)stringArray2[n2], (String)" \t");
            this.atoms = PApplet.parseInt((String)stringArray[0]);
            this.geom = new atom[this.atoms];
            ++n2;
            CloudView_15_fir2.println((String)("PRIMCORD: " + this.atoms));
        } else {
            n = n2;
            this.atoms = 0;
            while (stringArray2[n2].length() > 6) {
                ++n2;
                ++this.atoms;
            }
            CloudView_15_fir2.println((String)("ATOMS: " + this.atoms));
            this.geom = new atom[this.atoms];
            n2 = n;
        }
        n = 0;
        while (n < this.atoms) {
            CloudView_15_fir2.println((int)n);
            this.geom[n] = new atom();
            stringArray = CloudView_15_fir2.splitTokens((String)stringArray2[n2 + n], (String)" \t");
            this.geom[n].element = PApplet.parseInt((String)stringArray[0]);
            this.geom[n].x = PApplet.parseFloat((String)stringArray[1]);
            this.geom[n].y = PApplet.parseFloat((String)stringArray[2]);
            this.geom[n].z = PApplet.parseFloat((String)stringArray[3]);
            ++n;
        }
    }

    public void gencloud(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            float f = this.random((float)this.xDown + 0.01f, (float)this.xUp - 1.01f);
            float f2 = this.random((float)this.yDown + 0.01f, (float)this.yUp - 1.01f);
            float f3 = this.random((float)this.zDown + 0.01f, (float)this.zUp - 1.01f);
            float f4 = this.inter(f, f2, f3);
            float f5 = (f /= (float)(this.xs - 1)) * this.abc[0][0] + (f2 /= (float)(this.ys - 1)) * this.abc[1][0] + (f3 /= (float)(this.zs - 1)) * this.abc[2][0];
            float f6 = f * this.abc[0][1] + f2 * this.abc[1][1] + f3 * this.abc[2][1];
            float f7 = f * this.abc[0][2] + f2 * this.abc[1][2] + f3 * this.abc[2][2];
            f5 -= this.xsize * 0.5f;
            f6 -= this.ysize * 0.5f;
            f7 -= this.zsize * 0.5f;
            if (f4 > 0.0f && this.positive) {
                this.stroke(0.0f, 0.0f, 255.0f * f4 / this.fmax, 255.0f);
                this.point(f5 * this.zoom, f6 * this.zoom, f7 * this.zoom);
                ++n2;
            } else if (this.negative) {
                this.stroke(-255.0f * f4 / this.fmax, 0.0f, 0.0f, -255.0f);
                this.point(f5 * this.zoom, f6 * this.zoom, f7 * this.zoom);
                ++n2;
            }
            ++n3;
        }
    }

    public float inter(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((float)n <= f) {
            ++n;
        }
        while ((float)n2 <= f2) {
            ++n2;
        }
        while ((float)n3 <= f3) {
            ++n3;
        }
        float f4 = this.xyz[n - 1][n2 - 1][n3 - 1] * (1.0f - (f -= (float)(n - 1))) * (1.0f - (f2 -= (float)(n2 - 1))) * (1.0f - (f3 -= (float)(n3 - 1))) + this.xyz[n - 1][n2 - 1][n3] * (1.0f - f) * (1.0f - f2) * f3 + this.xyz[n - 1][n2][n3 - 1] * (1.0f - f) * f2 * (1.0f - f3) + this.xyz[n - 1][n2][n3] * (1.0f - f) * f2 * f3 + this.xyz[n][n2 - 1][n3 - 1] * f * (1.0f - f2) * (1.0f - f3) + this.xyz[n][n2 - 1][n3] * f * (1.0f - f2) * f3 + this.xyz[n][n2][n3 - 1] * f * f2 * (1.0f - f3) + this.xyz[n][n2][n3] * f * f2 * f3;
        return f4;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#ECE9D8", "CloudView_15_fir2"});
    }

    class atom {
        int element;
        float x;
        float y;
        float z;

        atom() {
        }
    }
}

