/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.CVector3f;
import controlP5.ControlBehavior;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindow;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerPlug;
import controlP5.ControllerSprite;
import controlP5.Label;
import controlP5.Tab;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Vector;
import processing.core.PApplet;

public abstract class Controller
implements ControllerInterface,
CDrawable,
ControlP5Constants {
    protected CVector3f position;
    protected CVector3f positionBuffer;
    protected CVector3f absolutePosition;
    protected ControllerInterface _myParent;
    protected String _myName;
    protected ControlWindow _myControlWindow;
    protected boolean isInside = false;
    protected boolean isMousePressed = false;
    protected ControlP5 controlP5;
    protected int width;
    protected int height;
    protected int _myId = -1;
    protected float _myValue;
    protected float _myDefaultValue;
    protected String _myStringValue = "";
    protected float[] _myArrayValue;
    protected Label _myCaptionLabel;
    protected Label _myValueLabel;
    protected boolean isLabelVisible = true;
    protected boolean isMoveable = true;
    protected boolean isBroadcast = true;
    protected boolean isVisible = true;
    protected boolean isActive = false;
    protected boolean isInit = false;
    protected Vector _myControlListener;
    protected CColor color = new CColor();
    protected float _myMin;
    protected float _myMax;
    protected float _myUnit;
    private ControllerPlug _myControllerPlug;
    protected String target;
    protected Object targetObject;
    protected ControlBehavior _myBehavior;
    protected boolean isBehavior;
    protected boolean isXMLsavable = true;
    protected Vector subelements;
    protected int myBroadcastType = 1;
    protected boolean isUpdate = false;
    public static final int MOVE = 0;
    public static final int RELEASE = 1;
    public static final int PRESSED = 2;
    protected int _myDecimalPoints = 2;
    protected ControllerSprite sprite;
    protected boolean isSprite;

    protected Controller(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, int n, int n2) {
        this.controlP5 = controlP5;
        if (this.controlP5 == null) {
            this.isBroadcast = false;
        }
        this._myName = string;
        this.position = new CVector3f(f, f2, 0.0f);
        this.positionBuffer = new CVector3f(f, f2, 0.0f);
        this.setParent(controllerGroup);
        if (controllerGroup != null) {
            this.color.set(controllerGroup.color);
        } else {
            this.color.set(this.controlP5.color);
        }
        this.width = n;
        this.height = n2;
        this._myCaptionLabel = new Label(string, this.color.colorLabel);
        this._myValueLabel = new Label("");
        this._myControlListener = new Vector();
        this.subelements = new Vector();
        this._myArrayValue = new float[0];
    }

    protected Controller(int n, int n2) {
        this.position = new CVector3f(n, n2, 0.0f);
    }

    public final void init() {
        this._myDefaultValue = this._myValue;
        this.controlP5.controlbroadcaster().plug(this._myName, this._myName);
        this.initControllerValue();
        this.isInit = this.controlP5.isAutoInitialization;
        this.setValue(this._myDefaultValue);
        this.isInit = true;
    }

    protected void updateFont(ControlFont controlFont) {
        this._myCaptionLabel.updateFont(controlFont);
        this._myValueLabel.updateFont(controlFont);
    }

    public void setBehavior(ControlBehavior controlBehavior) {
        this.isBehavior = true;
        this._myBehavior = controlBehavior;
        this._myBehavior.init(this);
    }

    public void removeBehavior() {
        this.isBehavior = false;
        this._myBehavior = null;
    }

    public ControlBehavior behavior() {
        return this._myBehavior;
    }

    public float defaultValue() {
        return this._myDefaultValue;
    }

    public void setDefaultValue(float f) {
        this._myDefaultValue = f;
    }

    public void setMoveable(boolean bl) {
        this.isMoveable = bl;
    }

    public void setLabelVisible(boolean bl) {
        this.isLabelVisible = bl;
    }

    private void initControllerValue() {
        if (this.controllerPlug() != null) {
            if (Float.isNaN(this.defaultValue())) {
                if (this.controllerPlug().value() == null) {
                    this.setDefaultValue(this.min());
                } else {
                    float f = 0.0f;
                    if (this.controllerPlug().value() instanceof Boolean) {
                        boolean bl = new Boolean(this.controllerPlug().value().toString());
                        f = bl ? 1.0f : 0.0f;
                    } else if (this.controllerPlug().value() instanceof Float) {
                        f = new Float(this.controllerPlug().value().toString()).floatValue();
                    } else if (this.controllerPlug().value() instanceof Integer) {
                        f = new Integer(this.controllerPlug().value().toString()).intValue();
                    } else if (this.controllerPlug().value() instanceof String) {
                        this._myStringValue = this.controllerPlug().value().toString();
                    }
                    this.setDefaultValue(f);
                }
            }
        } else if (Float.isNaN(this.defaultValue())) {
            this.setDefaultValue(this.min());
        }
        this._myValue = this._myDefaultValue;
    }

    public void setBroadcast(boolean bl) {
        this.isBroadcast = bl;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public CVector3f position() {
        return this.position;
    }

    public void setPosition(float f, float f2) {
        this.position.x = f;
        this.position.y = f2;
    }

    public CVector3f absolutePosition() {
        return this.absolutePosition;
    }

    public void updateAbsolutePosition() {
    }

    public final void continuousUpdateEvents() {
        if (this.isBehavior && this._myBehavior.isActive() && !this.isMousePressed) {
            this._myBehavior.update();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void updateEvents() {
        if (!this.isVisible) return;
        if (this.isMousePressed != this._myControlWindow.mouselock) return;
        if (this.isMousePressed) {
            if (ControlP5.keyHandler.isAltDown && this.isMoveable) {
                this.positionBuffer.x += (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX);
                this.positionBuffer.y += (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
                if (ControlP5.keyHandler.isShiftDown) {
                    this.position.x = (int)this.positionBuffer.x / 10 * 10;
                    this.position.y = (int)this.positionBuffer.y / 10 * 10;
                    return;
                }
                this.position.set(this.positionBuffer);
                return;
            }
        }
        if (this.isInside) {
            this._myControlWindow.isMouseOver = true;
        }
        if (this.inside()) {
            if (this.isInside) return;
            this.isInside = true;
            this.onEnter();
            return;
        }
        if (!this.isInside) return;
        if (this.isMousePressed) return;
        this.onLeave();
        this.isInside = false;
    }

    public void updateInternalEvents(PApplet pApplet) {
    }

    public void draw(PApplet pApplet) {
        if (this.inside()) {
            pApplet.fill(255.0f, 0.0f, 0.0f);
        } else {
            pApplet.fill(255);
        }
        pApplet.pushMatrix();
        pApplet.translate(this.position.x(), this.position.y(), this.position.z());
        pApplet.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
        pApplet.popMatrix();
    }

    public void add(ControllerInterface controllerInterface) {
        System.out.println("### ERROR @ Controller.register() not supported.");
    }

    public void remove(ControllerInterface controllerInterface) {
        System.out.println("### ERROR @ Controller.remove() not supported.");
    }

    public void remove() {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.controlP5 != null) {
            this.controlP5.remove(this);
        }
    }

    public String name() {
        return this._myName;
    }

    public void moveTo(String string) {
        this.setTab(string);
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).moveTo(string);
        }
    }

    public void moveTo(Tab tab) {
        this.setTab(tab.getWindow(), tab.name());
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).moveTo(tab);
        }
    }

    public void moveTo(PApplet pApplet) {
        this.setTab("default");
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).moveTo(pApplet);
        }
    }

    public void moveTo(PApplet pApplet, String string) {
        this.setTab(string);
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).moveTo(pApplet, string);
        }
    }

    public void moveTo(ControlWindow controlWindow) {
        this.setTab(controlWindow, "default");
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).moveTo(controlWindow);
        }
    }

    public void moveTo(ControlWindow controlWindow, String string) {
        this.setTab(controlWindow, string);
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).moveTo(controlWindow, string);
        }
    }

    public void moveTo(ControlGroup controlGroup, Tab tab, ControlWindow controlWindow) {
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).moveTo(controlGroup, tab, controlWindow);
        }
        if (controlGroup != null) {
            this.setGroup(controlGroup);
            return;
        }
        if (controlWindow == null) {
            controlWindow = this.controlP5.controlWindow;
        }
        this.setTab(controlWindow, tab.name());
    }

    public void moveTo(ControlGroup controlGroup) {
        if (controlGroup != null) {
            this.setGroup(controlGroup);
            return;
        }
    }

    public void setTab(String string) {
        this.setParent(this.controlP5.getTab(string));
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).setTab(string);
        }
    }

    public void setTab(ControlWindow controlWindow, String string) {
        this.setParent(this.controlP5.getTab(controlWindow, string));
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).setTab(controlWindow, string);
        }
    }

    public void setGroup(String string) {
        this.setParent(this.controlP5.getGroup(string));
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).setGroup(string);
        }
    }

    public void setGroup(ControllerGroup controllerGroup) {
        this.setParent(controllerGroup);
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((Controller)this.subelements.get(i)).setGroup(controllerGroup);
        }
    }

    public void setWindow(PApplet pApplet) {
        this.moveTo(pApplet);
    }

    public ControlWindow setWindow(ControlWindow controlWindow) {
        this.moveTo(controlWindow);
        return this._myControlWindow;
    }

    public Tab getTab() {
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    public final void setParent(ControllerInterface controllerInterface) {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        this.absolutePosition = new CVector3f(this.position);
        if (controllerInterface != null) {
            this._myParent = controllerInterface;
            this._myParent.add(this);
            this.absolutePosition.add(this._myParent.position());
            this._myControlWindow = this._myParent.getWindow();
        }
    }

    public ControllerInterface parent() {
        return this._myParent;
    }

    public ControlWindow getWindow() {
        return this._myControlWindow;
    }

    protected boolean inside() {
        return (float)this._myControlWindow.mouseX > this.position.x() + this._myParent.absolutePosition().x() && (float)this._myControlWindow.mouseX < this.position.x() + this._myParent.absolutePosition().x() + (float)this.width && (float)this._myControlWindow.mouseY > this.position.y() + this._myParent.absolutePosition().y() && (float)this._myControlWindow.mouseY < this.position.y() + this._myParent.absolutePosition().y() + (float)this.height;
    }

    public boolean isInside() {
        return this.isInside;
    }

    public boolean isMousePressed() {
        return this.isMousePressed;
    }

    protected void onEnter() {
    }

    protected void onLeave() {
    }

    protected void mousePressed() {
    }

    protected void mouseReleased() {
    }

    protected void mouseReleasedOutside() {
    }

    public final boolean setMousePressed(boolean bl) {
        if (!this.isVisible) {
            return false;
        }
        if (bl) {
            if (this.isInside) {
                this.isMousePressed = true;
                if (!ControlP5.keyHandler.isAltDown) {
                    this.mousePressed();
                }
                return true;
            }
        } else {
            if (this.isMousePressed && this.inside()) {
                this.isMousePressed = false;
                if (!ControlP5.keyHandler.isAltDown) {
                    this.mouseReleased();
                }
            }
            if (!this.inside()) {
                this.isInside = false;
                this.isMousePressed = false;
                this.mouseReleasedOutside();
            }
        }
        return false;
    }

    public void keyEvent(KeyEvent keyEvent) {
    }

    public void setId(int n) {
        this._myId = n;
    }

    public int id() {
        return this._myId;
    }

    protected ControllerPlug controllerPlug() {
        return this._myControllerPlug;
    }

    protected void setTarget(String string) {
        this.target = string;
    }

    protected void setTargetObject(Object object) {
        this.targetObject = object;
    }

    protected void setControllerPlug(ControllerPlug controllerPlug) {
        this._myControllerPlug = controllerPlug;
    }

    public abstract void setValue(float var1);

    public void setArrayValue(float[] fArray) {
        this._myArrayValue = fArray;
    }

    public final void changeValue(float f) {
        boolean bl = this.isBroadcast;
        this.isBroadcast = false;
        this.setValue(f);
        this.isBroadcast = bl;
    }

    public void update() {
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void trigger() {
        this.setValue(this.value());
    }

    public float value() {
        return this._myValue;
    }

    public String stringValue() {
        return this._myStringValue;
    }

    public float[] arrayValue() {
        return this._myArrayValue;
    }

    public CColor color() {
        return this.color;
    }

    public CColor getColor() {
        return this.color;
    }

    public void setLabel(String string) {
        this._myCaptionLabel.setFixedSize(false);
        this._myCaptionLabel.set(string);
        this._myCaptionLabel.setFixedSize(true);
    }

    public void setCaptionLabel(String string) {
        this._myCaptionLabel.setFixedSize(false);
        this._myCaptionLabel.set(string);
        this._myCaptionLabel.setFixedSize(true);
    }

    public void setValueLabel(String string) {
        this._myValueLabel.setFixedSize(false);
        this._myValueLabel.set(string);
        this._myValueLabel.setFixedSize(true);
    }

    public String label() {
        return this._myCaptionLabel.toString();
    }

    public void addListener(ControlListener controlListener) {
        this._myControlListener.add(controlListener);
    }

    public void removeListener(ControlListener controlListener) {
        this._myControlListener.remove(controlListener);
    }

    public int listenerSize() {
        return this._myControlListener.size();
    }

    protected void broadcast(int n) {
        n = this.myBroadcastType;
        ControlEvent controlEvent = new ControlEvent(this);
        for (int i = 0; i < this.listenerSize(); ++i) {
            ((ControlListener)this._myControlListener.get(i)).controlEvent(controlEvent);
        }
        if (this.isBroadcast && this.isInit) {
            this.controlP5.controlbroadcaster().broadcast(controlEvent, n);
        }
        this.isInit = true;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
        if (!bl) {
            this.isActive = false;
        }
    }

    public void hide() {
        this.isVisible = false;
        this.isActive = false;
    }

    public void show() {
        this.isVisible = true;
    }

    public void setColorActive(int n) {
        this.color.colorActive = n;
    }

    public void setColorForeground(int n) {
        this.color.colorForeground = n;
    }

    public void setColorBackground(int n) {
        this.color.colorBackground = n;
    }

    public void setColorLabel(int n) {
        this.color.colorLabel = n;
        this._myCaptionLabel.set(this._myCaptionLabel.toString(), this.color.colorLabel);
    }

    public void setColorValue(int n) {
        this.color.colorValue = n;
        if (this._myValueLabel != null) {
            this._myValueLabel.set(this._myValueLabel.toString(), this.color.colorValue);
        }
    }

    public Label captionLabel() {
        return this._myCaptionLabel;
    }

    public Label valueLabel() {
        return this._myValueLabel;
    }

    public float max() {
        return this._myMax;
    }

    public float min() {
        return this._myMin;
    }

    public void setMin(float f) {
        this._myMin = f;
    }

    public void setMax(float f) {
        this._myMax = f;
    }

    public Controller setWidth(int n) {
        this.width = n;
        return this;
    }

    public Controller setHeight(int n) {
        this.height = n;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setDecimalPrecision(int n) {
        this._myDecimalPoints = n;
        this._myValueLabel = new Label("" + (this.adjustValue(this._myMax).length() > this.adjustValue(this._myMin).length() ? this.adjustValue(this._myMax) : this.adjustValue(this._myMin)), this.color.colorValue);
        this._myValueLabel.set("" + this.adjustValue(this._myValue));
    }

    protected String adjustValue(float f) {
        return this.adjustValue(f, this._myDecimalPoints);
    }

    protected String adjustValue(float f, int n) {
        String string;
        block5: {
            int n2;
            block4: {
                int n3;
                int n4;
                n2 = n + 1;
                if (this.controllerPlug() != null && this.controllerPlug().classType() == Integer.TYPE) {
                    n2 = 0;
                }
                if ((n4 = (string = "" + f).indexOf(46)) <= 0) break block4;
                if (n == 0) {
                    --n4;
                }
                if ((n3 = (string = string.substring(0, Math.min(string.length(), n4 + n2))).length() - n4) >= n2) break block5;
                for (int i = 0; i < n2 - n3; ++i) {
                    string = string + "0";
                }
                break block5;
            }
            string = string + ".";
            for (int i = 0; i < n2; ++i) {
                string = string + "0";
            }
        }
        return string;
    }

    public ControlWindow controlWindow() {
        return this._myControlWindow;
    }

    public void setSprite(ControllerSprite controllerSprite) {
        this.sprite = controllerSprite;
        this.width = this.sprite.width();
        this.height = this.sprite.height();
        this.isSprite = true;
    }

    public void enableSprite() {
        if (this.sprite != null) {
            this.isSprite = true;
        }
    }

    public void disableSprite() {
        this.isSprite = false;
    }

    public boolean isXMLsavable() {
        return this.isXMLsavable;
    }

    public ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("label", this._myCaptionLabel.toString());
        controlP5XMLElement.setAttribute("id", new Integer(this.id()));
        controlP5XMLElement.setAttribute("value", new Float(this.value()));
        controlP5XMLElement.setAttribute("x", new Float(this.position().x()));
        controlP5XMLElement.setAttribute("y", new Float(this.position().y()));
        controlP5XMLElement.setAttribute("width", new Integer(this.width));
        controlP5XMLElement.setAttribute("height", new Integer(this.height));
        controlP5XMLElement.setAttribute("visible", new Float(this.isVisible ? 1.0f : 0.0f));
        controlP5XMLElement.setAttribute("moveable", new Float(this.isMoveable ? 1.0f : 0.0f));
        this.addToXMLElement(controlP5XMLElement);
        return controlP5XMLElement;
    }
}

