float[][][] xyz;
float[][] abc;
int xs,ys,zs,nums;
int xUp,yUp,zUp;
int xDown,yDown,zDown;

int words = 5;


class atom{
int element;
float x,y,z;
}
atom[] geom;
int atoms=0;

///////////////////////////////
/// ----- LOAD 3D FUNC ----- //
///////////////////////////////

void load(){
  abc=new float[3][3];
  String[] lines;
  String[] pieces;

  lines = loadStrings("grid.xsf");

  String[] m=null;
  int i = 0;
  while(m==null){
    m = match(lines[i], "DATAGRID_3D_");  //FIND START OF GRID
    i++;
  }
  pieces=splitTokens(lines[i]," \t");    //LOAD GRID SIZE
  xs=int(pieces[0]);
  ys=int(pieces[1]);
  zs=int(pieces[2]);
  nums=xs*ys*zs;
  //println(xs+" "+ys+" "+zs+" "+nums);
  i+=2;
  xyz = new float[xs][ys][zs];            //ALLOCATE GRID
  for (int ii=0;ii<3;ii++){              //LOAD ABC MATRIX
    pieces=splitTokens(lines[i+ii]," \t");
    for (int iv=0;iv<3;iv++){
      abc[ii][iv]=float(pieces[iv]);
    }
  }

//print out ABC matrix
for (int ii=0;ii<3;ii++){
  String s=""; 
  for (int iv=0;iv<3;iv++){
  s+="\t"+abc[ii][iv];
}
println(s);
}
i+=3;
//fireball?
print(lines[i].length()+": ");
if(lines[i].length()!=0){words=1;i--;
println("fireball");
}else{println("vasp");}

i++;
  int lmax = (nums/words);              //LOAD XYZ GRID
  int num = 0;
  for(int ii=0;ii<lmax;ii++){
    pieces=splitTokens(lines[i+ii]," \t");
    for(int iw=0;iw<words;iw++){
      int x=num%xs;
      int y=(num/xs)%ys;
      int z=num/(xs*ys);
   //   println(x+" "+y+" "+z+" | "+num+" : "+pieces[iw]);
      xyz[x][y][z]=float(pieces[iw]);
      num++;
    }
  }
  println("Grid of size "+xs+" x "+ys+" x "+zs+" = "+nums+" datapoints loaded");
  
  //size of scene in rho_1 metric
  xsize = sqrt(sq(abc[0][0])+sq(abc[1][0])+sq(abc[2][0]));
  ysize = sqrt(sq(abc[0][1])+sq(abc[1][1])+sq(abc[2][1]));
  zsize = sqrt(sq(abc[0][2])+sq(abc[1][2])+sq(abc[2][2]));
  rsize = sqrt(sq(xsize)+sq(ysize)+sq(zsize));
  println("Cell size "+xsize+" x "+ysize+" x "+zsize+" | "+rsize+" ");
  
xUp=xs;yUp=ys;zUp=zs;
xDown=0;yDown=0;zDown=0;
  
}



///////////////////////////////
/// ---- LOAD GEOMETRY ----- //
///////////////////////////////


//////////// PRIMCORD ///////////////

void loadgeom(){
String[] lines;
String[] pieces;
lines = loadStrings("grid.xsf");
String[] m=null;
int i = 0;
while(m==null){
 m = match(lines[i], "PRIMCOORD");  //FIND START OF GRID
   i++;}
pieces=splitTokens(lines[i]," \t");
atoms = int(pieces[0]);
geom = new atom[atoms];
i++;
for(int ii=0;ii<atoms;ii++){
geom[ii] = new atom();
pieces=splitTokens(lines[i+ii]," \t");
geom[ii].element = int(pieces[0]);
geom[ii].x = float(pieces[1]);
geom[ii].y = float(pieces[2]);
geom[ii].z = float(pieces[3]);
}
}


///////////////// ATOMS ///////////////////

void loadgeom_ATOMS(){
String[] lines;
String[] pieces;
lines = loadStrings("grid.xsf");
String[] m=null;
int i = 0;
while(m==null){
 m = match(lines[i], "ATOMS");  //FIND START OF ATOMS
   i++;}
int iATOMS = i; // save start of block
atoms = 0; // find number of atoms
while(lines[i].length()>6){  
i++; atoms++;
}
println(atoms);
geom = new atom[atoms];

i=iATOMS; // back to start
//load atoms
for(int ii=0;ii<atoms;ii++){
 println(ii);
geom[ii] = new atom();
pieces=splitTokens(lines[i+ii]," \t");
geom[ii].element = int(pieces[0]);
geom[ii].x = float(pieces[1]);
geom[ii].y = float(pieces[2]);
geom[ii].z = float(pieces[3]);
}
}



/////////////// PRIMCORD OR ATOMS ///////////////

void loadgeom_BOTH(){
String[] lines;
String[] pieces;
lines = loadStrings("grid.xsf");
String[] m1=null;
String[] m2=null;
int i = 0;
while((m1==null)&&(m2==null)){
 m1 = match(lines[i], "ATOMS");  //FIND START OF ATOMS
 m2 = match(lines[i], "PRIMCOORD");  //FIND START OF PRIMCORD
   i++;}

if(m1 == null){
// "PRIMCORD" case
pieces=splitTokens(lines[i]," \t");
atoms = int(pieces[0]);
geom = new atom[atoms];
i++;
println("PRIMCORD: "+atoms);
}else{
// "ATOMS" case
int iATOMS = i; // save start of block
atoms = 0; // find number of atoms
while(lines[i].length()>6){  
i++; atoms++;
}
println("ATOMS: "+atoms);
geom = new atom[atoms];
i=iATOMS; // back to start
}

//load atoms
for(int ii=0;ii<atoms;ii++){
 println(ii);
geom[ii] = new atom();
pieces=splitTokens(lines[i+ii]," \t");
geom[ii].element = int(pieces[0]);
geom[ii].x = float(pieces[1]);
geom[ii].y = float(pieces[2]);
geom[ii].z = float(pieces[3]);
}
}




