#!/usr/bin/python

from pylab import *

lvs = array([[1,0,0],[0.5,0.5,0],[0,0,1]])
ilvs = transpose(linalg.inv(lvs))*2*3.14159265359

fig = figure(figsize=(6,6))
grid(); axes();
sz=3.0*ilvs[0:2][0:2].max();  xlim(-sz, sz); ylim(-sz, sz);

# real space
arrow(  0, 0, lvs[0][0], lvs[0][1], head_width=0.05*sz, head_length=0.1*sz, fc='k', ec='k')
arrow(  0, 0, lvs[1][0], lvs[1][1], head_width=0.05*sz, head_length=0.1*sz, fc='k', ec='k')
# reciprocal space
arrow(  0, 0, ilvs[0][0], ilvs[0][1], head_width=0.05*sz, head_length=0.1*sz, fc='r', ec='r')
arrow(  0, 0, ilvs[1][0], ilvs[1][1], head_width=0.05*sz, head_length=0.1*sz, fc='r', ec='r')

def rot(v,a):
	vv = zeros(2)
	vv[0] = v[0]*cos(a)-v[1]*sin(a)
	vv[1] = v[0]*sin(a)+v[1]*cos(a)
	return vv

a = 30    *3.14159265359/180.0
M = (0.5*ilvs[0])[0:2]
K = rot( M, a)  / cos(a)
K2 = rot( M, a*3)  / cos(a)
KK = K-K2

KT = array([K[1],-K[0]]) 

print M
print K

ax=gca()
ax.add_patch(  Circle(M,radius=0.02*sz)    ) 
ax.add_patch(  Circle(K,radius=0.02*sz)    ) 


#ts = arange(0,3,0.01)  
# Kpts = outer(K,ts)   #  Gamma -> K
# Kpts = transpose(add( outer(ts,KK), K2))   # K2-> K 

ts = arange(-1,1,0.01)  
Kpts = transpose(add( outer(ts,KT), K))   # K2-> K 

#print Kptss
plot(Kpts[0],Kpts[1],'.')

show()




