#!/usr/bin/python

import Element
import pylab
import struct

# Atoms

def povAtoms( povfile, xyz, selectedatoms=None, x0=(0,0,0),  atomscale=0.5, alfa=1.0 ):
	povfile.write(" //============== Atoms\n");
	if selectedatoms is None:
		selectedatoms = range(len(xyz[0]))
	for i in selectedatoms:
		e = xyz[0][i]-1
		clr = Element.clr[e];
		s = 'a( %10.5f, %10.5f, %10.5f,      %10.5f,     %10.5f, %10.5f, %10.5f,     %10.5f ) \n' %( xyz[1][i]-x0[0],xyz[2][i]-x0[1],xyz[3][i]-x0[2], atomscale*Element.rad[e], clr[0]/255.0,clr[1]/255.0,clr[2]/255.0, 1.0-alfa )
		povfile.write(s);

# PDOS

def povDosAtoms( povfile, xyz, DOSsum, selectedatoms=None, x0=(0,0,0), dosscale=1.0, atomscale=0.5 ):
	if selectedatoms is None:
		selectedatoms = range(len(xyz[0]))
	povfile.write(" //============== PDOS Atom Spheres\n");
	for i in selectedatoms:
		e = xyz[0][i]-1
		clr = Element.clr[e];
		alfa = min(1.0,max(0.0,DOSsum[i]/dosscale))
		s = 'a( %10.5f, %10.5f, %10.5f,      %10.5f,     %10.5f, %10.5f, %10.5f,     %10.5f ) \n' %( xyz[1][i]-x0[0],xyz[2][i]-x0[1],xyz[3][i]-x0[2], atomscale*Element.rad[e], clr[0]/255.0,clr[1]/255.0,clr[2]/255.0, 1.0-alfa )
		povfile.write(s);

# Bonds

def povBonds( povfile, xyz, bonds, x0=(0,0,0), bondw=0.1 ):
	povfile.write(" //============== Bonds\n");
	for k in xrange(len(bonds)):
		i = bonds[k][0]; j = bonds[k][1]
		clr1= Element.clr[xyz[0][i]-1]; clr2= Element.clr[xyz[0][j]-1]
		clr =[ (clr1[0] + clr2[0]) * 0.5, (clr1[1] + clr2[1]) * 0.5, (clr1[2] + clr2[2]) * 0.5 ]
		s= 'b( %10.5f, %10.5f, %10.5f, %10.5f, %10.5f, %10.5f, %10.5f, %10.5f, %10.5f, %10.5f,0.0 ) \n' %( xyz[1][i]-x0[0],xyz[2][i]-x0[1],xyz[3][i]-x0[2], xyz[1][j]-x0[0],xyz[2][j]-x0[1],xyz[3][j]-x0[2], bondw, clr[0]/255.0,clr[1]/255.0,clr[2]/255.0 )
		povfile.write(s); 


# numpy array -> d3f

def exportDF3( F, name='temp.df3', depth=32):
	fmax = F.max(); fmin = F.min()
	#print "fmin,fmax: ",fmin,fmax
	F = (F-fmin)/(fmax-fmin)
	nDim = pylab.shape(F)
	#print nDim
	F = F.flat[:] * 4294967295
	F = F.astype(int)
	n = len(F)
	#print n
	f = open(name+".df3", 'wb');
	f.write(struct.pack('>HHH', nDim[2], nDim[1], nDim[0]))
	for i in range( n ):
			f.write(struct.pack('>I', F[i]))
	return fmin,fmax

# 3Ddata

def pov3Ddata( povfile, name='temp', interpolate=2 ):
	povfile.write( '#declare data3d_%s = function { pattern { density_file df3 "%s.df3" interpolate %i frequency 0 } }\n' %(name,name,interpolate) )


# iso surface


"""
def povIsoDF3( povfile, isoval, fmin, fmax, sign=1, sz=(1,1,1), color=(0.5,0.5,0.5), name='temp' ):
	nu = ( isoval - fmin ) / ( fmax - fmin )
	povfile.write( '''
isosurface {
	function     {  %f*( %f - data3d_%s(x,y,z) )  }
	contained_by { box { <0.01,0.01,0.01>,<0.99,0.99,0.99> } }
    max_gradient 1
    pigment { color rgbt <%f,%f,%f,%f> }
    finish{ phong 0.8}
	no_shadow
	rotate 90*x
	scale <%f,%f,%f>
	translate -0.5*<%f,-2*%f,%f> 
}''' %(  sign, nu, name,   color[0],color[1],color[2],color[3],    sz[0],sz[2],sz[1]   ,sz[0],sz[2],sz[1]  ) )
"""


def povIsoDF3( povfile, isoval, fmin, fmax, sign=1, boxMin=(0.01,0.01,0.01), boxMax=(0.99,0.99,0.99), start=(-1.0,-1.0,-1.0), sz=(2.0,2.0,2.0), color=(0.5,0.5,0.5,0.0), name='temp' ):
	nu = ( isoval - fmin ) / ( fmax - fmin )
	povfile.write( '''
isosurface {
	function     {  %f*( %f - data3d_%s(x,y,z) )  }
	contained_by { box { <%f,%f,%f>,<%f,%f,%f> } }
    max_gradient 20
	accuracy 0.000001
    pigment { color rgbt <%f,%f,%f,%f> }
    finish{ phong 0.8}
	no_shadow
	scale <%f,%f,%f>
	translate <%f,%f,%f> 
}''' %(  (  sign, nu, name ) + boxMin + boxMax + (  color[0],color[1],color[2],color[3],    sz[0],sz[1],sz[2],  start[0],start[1],start[2]  ) ) )




'''
        //scattering {1, COLOR*FACTOR  extinction 1 }
        //scattering {1, COLOR*FACTOR  extinction 0 }
        absorption (<1.0,1.0,1.0>-COLOR)*FACTOR
        // intervals 1
        samples 5 method 3 
		density { density_file df3 "%s.df3" }
'''

def povDensDF3( povfile, factor=1, lowbound=0.5, start=(-1.0,-1.0,-1.0), sz=(2.0,2.0,2.0), color=(0.5,0.5,0.5), name='temp' ):
	povfile.write( '''
box { <0.01,0.01,0.01>,<0.99,0.99,0.99> 
  hollow
  #local COLOR  = <%f,%f,%f,%f>;   
  #local FACTOR = %f;
  texture { pigment { color <1.0,1.0,1.0,1.0> filter 1} finish { ambient 0 diffuse 0 } }
  interior {   ior 1.0 media {
		intervals 100
		ratio 0.5
		samples 2,2
		method 2
      //emission <1,1,1> 
	   scattering {1, COLOR*FACTOR  extinction 0 }
       absorption (<1.0,1.0,1.0>-COLOR)*FACTOR
      confidence 0.999
      variance 1/1000
      density {
        	density_file df3 "%s.df3" 
			interpolate 1
			color_map {
			[0.001 rgb <0 0 0>]
			[ %f rgb <0 0 0>]
			[0.99  rgb <1,1,1>]
   			[0.991 rgb <0,0,0>]
			}
		}
	} }
	no_shadow
	scale <%f,%f,%f>
	translate <%f,%f,%f> 
}''' %( color[0],color[1],color[2],color[3],  factor, name, lowbound,  sz[0],sz[1],sz[2],  start[0],start[1],start[2]  ) )


def povRelief( povfile, start=(-1.0,-1.0,-1.0), sz=(2.0,2.0,2.0), color=(0.5,0.5,0.5,0.0), name='temp'):
	povfile.write( '''
intersection { 
	height_field{ png "%s.png" smooth rotate <-90,0,0> } 
	box{ <0.01,0.01,0.01> <0.99,0.99,-0.99> }
	scale<%f,%f,%f> translate<%f,%f,%f> pigment{ color rgbt <%f,%f,%f,%f>}  finish{phong 0.5} no_shadow
} ''' %( name, sz[0],sz[1],sz[2],  start[0],start[1],start[2], color[0],color[1],color[2],color[3] ) ) 



def povTrajectory(povfile, xyzs, r, color=(0.5,0.5,0.5), lw=1.0, rmax=1000, withCones=True, withSpheres=True, imin=0, imax=None ):
	povfile.write('union{\n')
	if imax is None:
		imax = len(xyzs)-1
	opos = xyzs[imin]
	ori =  r if isinstance(r, float    ) else r[imin]
	#print " imin,imax,opos,ori ", imin,imax,opos,ori
	for i in range(imin+1,imax+1):
		pos = xyzs[i] 
		ri     = r     if isinstance(r, float    ) else r[i]
		colori = color if isinstance(color, tuple) else color[i]
		dpos = pos - opos 
		dist = pylab.sqrt( pylab.dot(dpos,dpos) )
		#print i,r,rmax,ri,ori, colori
		if(dist<rmax):
			if (withCones):   povfile.write( "cone{<%3.5f,%3.5f,%3.5f>,%3.5f<%3.5f,%3.5f,%3.5f>,%3.5f pigment{rgbt<%3.5f,%3.5f,%3.5f,0.0>} } \n"  %(opos[0],opos[1],opos[2],ori*lw,pos[0],pos[1],pos[2],ri*lw,colori[0],colori[1],colori[2]) )
			if (withSpheres): povfile.write( "sphere{<%3.5f,%3.5f,%3.5f>,%3.5f pigment{rgbt<%3.5f,%3.5f,%3.5f,0.0>} } \n"  %(pos[0],pos[1],pos[2],ri,colori[0],colori[1],colori[2]) )
		else:
			break
		opos=pos; ori=ri
	#povfile.write('rotate <0,0,0>\n')
	povfile.write('no_shadow\n')
	povfile.write('}\n')




# ====================== Debuging 

def povAxes(povfile, length=1, lw=0.1, cone=4 ):
	povfile.write( '''
#declare axlen   = %f;
#declare axwidth = %f;           
cylinder {  <-axlen,0,0>,  <axlen, 0, 0>,  axwidth   pigment { color rgb <1,0,0> } }    
cylinder {  <0,-axlen,0>,  <0, axlen, 0>,  axwidth   pigment { color rgb <0,1,0> } }   
cylinder {  <0,0,-axlen>,  < 0, 0, axlen>, axwidth   pigment { color rgb <0,0,0> } }   
''' %(length,lw) ) 
	if cone>0:
		povfile.write( ''' 
#declare axcone = %f*axwidth;
cone {  <axlen+axcone, 0, 0>, 0, <axlen, 0, 0>, axcone   pigment { color rgb <1,0,0> }  }
cone {  <0, axlen+axcone, 0>, 0, <0, axlen, 0>, axcone    pigment { color rgb <0,1,0> }  }
cone {  <0, 0, axlen+axcone>, 0, <0, 0, axlen>, axcone    pigment { color rgb <0,0,2> }  }
''' %(cone) )

def povBoundBox(povfile, lw=0.1, start=(-1,-1,-1), sz=(2,2,2) ):
	povfile.write( '''box{<%f,%f,%f><%f,%f,%f> pigment { color rgbt <1.0,1.0,1.0,0.5> } }''' %(start[0],start[1],start[2], start[0]+sz[0],start[1]+sz[1],start[2]+sz[2] ))
	
# ====================== Typical Header

def povHeader( povfile, camPos, zoom, aspect=1, lookAt=(0,0,0), angle=0, bgColor = (0.5,0.5,0.5), lightPos=None, lightColor=(0.5,0.5,0.5), b_macro=True, a_macro=True, defaultFinish=True ):
	povfile.write('#declare zoom        = %f ; \n' %zoom)
	povfile.write('#declare aspectRatio = %f ; \n' %aspect)
	povfile.write('#declare camPos      = <%f,%f,%f> ; \n' %(camPos[0],camPos[1],camPos[2]) )
	povfile.write('#declare camTarget   = <%f,%f,%f> ; \n' %(lookAt[0],lookAt[1],lookAt[2]) )
	if (angle==0):
		povfile.write(''' 
camera{
	orthographic
	location camPos
	sky           z
	up       zoom*z
	right    zoom*y*aspectRatio
	look_at camTarget
}
		''')
	else:
		povfile.write(''' 
camera{
  location camPos*zoom
  sky z
  up z
  right y*aspectRatio
  look_at camTarget
  angle %f
}
''' %angle)

	if defaultFinish:
		povfile.write(''' 
#declare atom_finish = finish {
  ambient 0.5
  diffuse 0.8
  specular 0.90
  roughness .02
  metallic
  phong 0.1
  phong_size 0.1
}
		''')
	if b_macro:
		povfile.write(''' 
#macro b(X1,Y1,Z1,X2,Y2,Z2,RADIUS2,R,G,B,T)
 cylinder{<X1,Y1,Z1>,<X2,Y2,Z2>,RADIUS2
  pigment{rgbt<R,G,B,T>  }
  finish{atom_finish}
  no_shadow
  }
#end
		''')
	if a_macro:
		povfile.write(''' 
#macro a(X,Y,Z,RADIUS,R,G,B,T)
 sphere{<X,Y,Z>,RADIUS
  pigment{rgbt<R,G,B,T>}
  finish{atom_finish}
  no_shadow
  }
#end
		''')
	povfile.write( "background      { color rgb  <%f,%f,%f> } \n" %( bgColor[0],bgColor[1],bgColor[2] )  )
	if lightPos is not None:
		povfile.write("light_source  {  <%f,%f,%f> rgb <%f,%f,%f> } \n" %(  lightPos[0],lightPos[1],lightPos[2],  lightColor[0],lightColor[1],lightColor[2] ) )
	

# ====================== LEGACY


# Lenard_Jones

def povAtomsLJ( povfile, xyz, LJparams , selectedatoms=None, x0=(0,0,0),  isoval=1, color=(0.5,0.5,0.5) ):
	if selectedatoms is None:
		selectedatoms = range(len(xyz[0]))
	povfile.write(''' //============== LJ isosurf
#declare fr2 = function(x,y,z){x*x+y*y+z*z};
#declare fpow2 = function(x){x*x};
#declare fpow3 = function(x){x*x*x};
#declare fLJ = function(x,y,z, C6, C12){ C12/fpow2( fpow3( fr2(x,y,z) ) ) -  C6/fpow3( fr2(x,y,z) ) }

#macro LJfunc()
''')
	for i in selectedatoms:
		R = LJparams[i][0]
		E = LJparams[i][1]
		C6  = 2*E*(R**6)
		C12 = E*(R**12)
		povfile.write(" + fLJ( x-%10.5f, y-%10.5f, z-%10.5f, %10.5f, %10.5f )\n"  %( xyz[1][i]-x0[0],xyz[2][i]-x0[1],xyz[3][i]-x0[2], C6, C12 )  );
	povfile.write('''
#end
 
#macro LJIso( ISOVAL, COLOR )
isosurface { 
  function{
    (  LJfunc() )/ ISOVAL
  } 
  threshold -1.0
  contained_by {sphere {<0,0,0> 20}}
  max_gradient 6
  //accuracy 0.0001 
  //evaluate 10.0, 1.29, 0.7 
  hollow
  texture {
      pigment { color COLOR }
      finish {
        ambient 0.1 diffuse 0.9 phong 1
      }
  }
}
#end
''')
	povfile.write("LJIso(%f ,<%f,%f,%f>)" %(isoval,color[0],color[1],color[2])  );


# Orthographic Camera

def camOrtho(povfile, loc, zoom, aspect=1 ):
	povfile.write('#declare Zoom   = %f ; \n' %zoom)
	povfile.write('#declare aspectRatio  = %f ; \n' %aspect)
	s='''
	camera{
  	   orthographic
  	   location < %f , %f, %f>
	   sky           z
	   up       Zoom*z
	   right    Zoom*y*aspectRatio
	   look_at < 0.0, 0.0, 0.0 >
	}
	''' %(loc[0],loc[1],loc[2] )
	povfile.write(s)
	


# Typical Header


s_JmolHead = '''
// ***********************************************
// Camera & other global settings
// ***********************************************

background      { color rgb <0.5,0.5,0.5> }
light_source    { < 10,20,30>  rgb <0.5,0.5,0.5> }
global_settings { 
ambient_light rgb< 0.8, 0.8, 0.8> 
max_trace_level 20 
} 

// ***********************************************
// macros for common shapes
// ***********************************************

#default { finish {
  ambient 0.5
  diffuse 0.8
  specular 0.90
  roughness .02
  metallic
  phong 0.1
  phong_size 0.1
}
}

#macro a(X,Y,Z,RADIUS,R,G,B,T)
 sphere{<X,Y,Z>,RADIUS
  pigment{rgbt<R,G,B,T>}
  no_shadow
  }
#end

#macro b(X1,Y1,Z1,X2,Y2,Z2,RADIUS2,R,G,B,T)
 cylinder{<X1,Y1,Z1>,<X2,Y2,Z2>,RADIUS2
  pigment{rgbt<R,G,B,T>  }
  no_shadow
  }
#end

// ********************************
//   Atom Data
// ********************************

'''
