#!/usr/bin/python

from math import *

def cross(a,b):
	x = [None]*len(a)
	x[0] = a[1]*b[2] - a[2]*b[1]
	x[1] = a[2]*b[0] - a[0]*b[2]
	x[2] = a[0]*b[1] - a[1]*b[0]	
	return x

def fadd(a,b,f):
	x = [None]*len(a)
 	x[0]=a[0]+f;   x[1]=a[1]+f;  x[2]=a[2]+f
	return x

def add(a,b,f):
	x = [None]*len(a)
 	x[0]=a[0]+f*b[0];   x[1]=a[1]+f*b[1];  x[2]=a[2]+f*b[2]
	return x

def fmul(a,f):
	x = [None]*len(a)	
 	x[0]=f*a[0];   x[1]=f*a[1];  x[2]=f*a[2]
	return x

def mul(a,b):
	x = [None]*len(a)	
	x[0]=a[0]*b[0];   x[1]=a[1]*b[1];  x[2]=a[2]*b[2]
	return x

def mulmat(a,b,c,d):
	x = [None]*len(a)
	x[0]=a[0]*b[0]+a[1]*b[1]+a[2]*b[2]
	x[1]=a[0]*c[0]+a[1]*c[1]+a[2]*c[2]
	x[2]=a[0]*d[0]+a[1]*d[1]+a[2]*d[2]
	return x

def orient( rs, mat ):
	rs2     = [None]*len(rs)
	for i in range(len(rs)):
		rs2[i]=mulmat( rs[i], mat[0],mat[1],mat[2] )
	return rs2

def div(a,b):
	x = [None]*len(a)	
 	x[0]=a[0]/b[0];   x[1]=a[1]/b[1];  x[2]=a[2]/b[2]
	return x

def dot(a,b):
	f= a[0]*b[0] + a[1]*b[1] + a[2]*b[2]
	return f

def someOrtho(axis, Up=None ):
	uax = fmul(axis, 1.0/sqrt( dot(axis,axis) ) )
	v = None
	u = None
	print Up
	if Up is not None:
		#print "===== UpVector given"
		v = fmul(Up, 1.0/sqrt( dot(Up,Up) ) )
		u = cross( uax, v )
		v = cross( uax, u ) 
	else:
		#print "===== UpVector not given"
		v = cross( uax, [1,0,0] )
		f = dot(v,v)
		if f<0.01:
			v = cross( uax, [0,1,0] )
			f = dot(v,v)
		v = fmul(v,1.0/sqrt(f))
		u = cross( uax, v )
	return uax,v,u

def shift( rs, axis, f ):
	rs2     = [None]*len(rs)
	for i in range(len(rs)):
		rs2[i] =  add( rs[i], axis, f)
	return rs2

def rotate( rs, center, axis, angle ):
	rs2     = [None]*len(rs)
	ax,u,v = someOrtho(axis)
	print "ax", ax
	print " u", u
	print " v", v
	ca = cos(angle)
	sa = sin(angle)
	print ca, sa
	for i in range(len(rs)):
		r      =  add( rs[i], center, -1)  # sift by center
		rax    = fmul(  ax, dot( r,ax) )  # axial r
		fv     = dot( r,v )  # v componet  of r
		fu     = dot( r,u )  # u component of r
		ruv2   =  add( fmul( v, fv*ca - fu*sa  ), fmul( u, fv*sa + fu*ca  )  , 1)
		rax    =  add( rax, center , 1)
		rs2[i] =  add( rax, ruv2 , 1)
		#print rs2[i] 
	return rs2

def loadXyz(name):
	f = open(name,"r")
	n = int(f.readline())
	e   = [None]*n 
	xyz = [None]*n
	f.readline()
	for i in range(n):
		l=f.readline().split()
		e  [i] = l[0]
		xyz[i] = [	float(l[1]), float(l[2]), float(l[3]) ] 
	f.close()
#	print(len(xyz))
	return [e,xyz]

def loadLvs(name):
	lvs = [None]*3
	f = open(name,"r")
	for i in range(3):
		l=f.readline().split()
		lvs[i] = [ float(l[0]), float(l[1]), float(l[2]) ]
	f.close()
	return lvs

def writeXyz(f,xyzs):
	for i in range(len(xyzs[0])):
		xyz = xyzs[1][i]
		f.write( xyzs[0][i] + "  %10.5f  %10.5f  %10.5f \n" %(xyz[0],xyz[1],xyz[2]) )
	return xyzs
