

import pylab
import xsfutil
import basUtils

'''
#usage:

import xsfutil
import STHM
from os import *
chdir('/home/prokop/Desktop/Dorje/SHTM/SHTM_relax/PTCDA_7x_CO_KxScan/Kx0.05')
Xs=xsfutil.loadXSF('OutX.xsf')
Ys=xsfutil.loadXSF('OutY.xsf')
[35,38,40,43,45,48,50,53,55,58]
[40,45,50,55]
STHM.plot_xsf_scatter(Xs,Ys,[45])

bas = basUtils.loadBas('../surf.bas')[0]

getcwd()
'''

# ======== 2D plot : Make points of scatter plot from 1 slice of xsf file

def slice2scatter(Xs,Ys, lvec):
	nx = len(Xs)
	ny = len(Xs[0])
	Ps = pylab.mgrid[0:nx,0:ny].astype(float)
	Ps[0] *= (lvec[1,0]/float(nx))
	Ps[1] *= (lvec[2,1]/float(ny))
	#print Xs
	#print Ys
	#Ps[0] += lvec[0,0]
	Ps[0] += Ys + lvec[0,0]
	Ps[1] += Xs + lvec[0,1]
	return Ps

def plot_xsf_scatter(Xxsf,Yxsf,xyz, ilist, dz=0.1, show=True, save=True ):
	Xs = Xxsf[0]
	Ys = Yxsf[0]
	lvec = Xxsf[1]
	nDim = Xxsf[2]
	lvec[0,0] = -7
	lvec[0,1] = -7
	n=len(ilist)
	pylab.figure( figsize=(25,2+(25.0/n) ) );
	for i in range(n):
		ii = ilist[i]
		print i,ii
		pylab.subplot(1,n,i+1);
		pylab.title( "z=%2.2f$\AA$" %(dz*ii)  );
		extent=( lvec[0,0], lvec[1,0]+lvec[0,0] ,   lvec[0,1],    lvec[2,1]+lvec[0,1]  )
		pylab.imshow( Xs[ii]*0,  extent=extent,  origin='image', cmap = 'binary' ) 
		Ps = slice2scatter(Xs[ii],Ys[ii], lvec)
		pylab.scatter( Ps[1].flat, Ps[0].flat, s=1,   c='#FF0000', edgecolors='none'  )
		pylab.scatter( xyz[1], xyz[2], s=pylab.sqrt(xyz[0])*10,   c='#FFFFFF'  )
		pylab.xlim(extent[0],extent[1])
		pylab.ylim(extent[2],extent[3])
	if save:
		pylab.savefig( 'points_all.png', bbox_inches='tight', pad_inches=0)
	if show:
		pylab.show();
