
subroutine sampleSurf( scaleFF, system, FF )
	use G_globals
	implicit none
! === Parameters
	real               , intent(in)     :: scaleFF
	type (subSystem)   , intent(in)     :: system
	type (grid3Dvec3)  , intent(inout)  :: FF
! === variables
	integer ix,iy,iz
	real    Esond
	real, dimension (3) :: Rsond, Fsond, Rshift
	real fmag2
! === Body
	write (*,*) " DEBUG scaleFF : ", scaleFF
	do ix = 1, FF%N(1)
		Rsond(1) = FF%Rmin(1) + ix * FF%step(1)
		write (*,*) " ix: ", ix
		do iy = 1, FF%N(2)         
			Rsond(2) = FF%Rmin(2) + iy * FF%step(2)                     
			do iz = 1, FF%N(3)
				Rsond(3) = FF%Rmin(3) + iz * FF%step(3)
				Fsond(:) = 0.0 
				call getFF_LJ  ( Rsond, sondZ, system, Esond, Fsond )   ! sample inside cell
				if ( sampleOuside .gt. 0 ) then                         ! sample neighboring cells
					Rshift(:) = 0.D0
					Rshift(1) = FF%Rspan(1)  
					call getFF_LJ  ( Rsond + Rshift, sondZ, system, Esond, Fsond )
					call getFF_LJ  ( Rsond - Rshift, sondZ, system, Esond, Fsond )
					Rshift(:) = 0.D0
					Rshift(2) = FF%Rspan(2)  
					call getFF_LJ  ( Rsond + Rshift, sondZ, system, Esond, Fsond )
					call getFF_LJ  ( Rsond - Rshift, sondZ, system, Esond, Fsond )
					Rshift(:) = 0.D0
					Rshift(1) = FF%Rspan(1) 
					Rshift(2) = FF%Rspan(2) 
					call getFF_LJ  ( Rsond + Rshift, sondZ, system, Esond, Fsond )
					call getFF_LJ  ( Rsond - Rshift, sondZ, system, Esond, Fsond )
					Rshift(:) = 0.D0
					Rshift(1) =  FF%Rspan(1) 
					Rshift(2) = -FF%Rspan(2) 
					call getFF_LJ  ( Rsond + Rshift, sondZ, system, Esond, Fsond )
					call getFF_LJ  ( Rsond - Rshift, sondZ, system, Esond, Fsond )
				end if
				fmag2 = dot_product( Fsond, Fsond )
				if (fmag2 .gt. FgridMaxSq ) Fsond(:) = Fsond(:)*sqrt(FgridMaxSq/fmag2)   ! just to remove very high numbers from data grids
				FF%f(:,ix,iy,iz) = FF%f(:,ix,iy,iz) + scaleFF * Fsond(:)
				! FF%f(:,ix,iy,iz) = scaleFF
			end do ! iz
		end do ! iy
	end do ! ix
end subroutine sampleSurf
