
program SHTM_1D
    use G_globals
  implicit none

! == Local Parameters and Data Declaration
! == Local Variable Declaration and Description
integer ix,iy,iz,nz

real xscan,yscan, zmin, zmax, zstep

real Esond, Etip
real, dimension (3) :: Rtip,Rsond, Fsond, Rtmp, Rsond0, Ftip

integer ipos,npos
real, dimension (:,:), allocatable :: poslist

real time_start,time_end

! == Procedure

write (*,*) " >> Reading SHTM_1D.ini"
  open (unit = 69, file = "SHTM_1D.ini", status = 'old')
  read (69,*) wrtDebug
  read (69,*) relaxMethod
  read (69,*) dt, convergF, damping,startKick, maxRelaxIter  
  read (69,*) kMorse 
  read (69,*) kHarmonic
  read (69,*) RspringMin
  read (69,*) sondZ
  read (69,*) xscan, yscan
  read (69,*) zmax, zmin, zstep
  close (69)

nz = floor((zmax - zmin)/zstep)

  ! atomic parameters
write (*,*) " >> Read atomic positions and parameters "
call readspecies()
call surf%fromfile( 'surf.bas' )
call tip%fromfile ( 'tip.bas'  )


open (unit = 69, file = "poslist.ini", status = 'old')
	read (69,*) npos
	allocate( poslist(3,npos) )
	do ipos = 1,npos
		read (69,*) Rtmp(:)
		poslist(1,ipos) =  (  atypes( tip%Zs(1) )%R0 + atypes( SondZ )%R0  ) * Rtmp(1) * sin( 2*3.14159265359*Rtmp(2) ) * cos( 2*3.14159265359*Rtmp(3) )
		poslist(2,ipos) =  (  atypes( tip%Zs(1) )%R0 + atypes( SondZ )%R0  ) * Rtmp(1) * sin( 2*3.14159265359*Rtmp(2) ) * sin( 2*3.14159265359*Rtmp(3) )
		poslist(3,ipos) = -(  atypes( tip%Zs(1) )%R0 + atypes( SondZ )%R0  ) * Rtmp(1) * cos( 2*3.14159265359*Rtmp(2) )  
		if ( wrtDebug .gt. 0 ) write(*,'(A,i5,6f20.10)') " i, R,theta,phi, pos0 x,y,z: ", ipos,Rtmp(:), poslist(:,ipos)
	end do ! ipos

write (*,*) " >> TIP sampling .... "
open (unit = 101, file = "m1D_E.dat", status = 'unknown')
open (unit = 102, file = "m1D_Fx.dat", status = 'unknown')
open (unit = 103, file = "m1D_Fy.dat", status = 'unknown')
open (unit = 104, file = "m1D_Fz.dat", status = 'unknown')
open (unit = 105, file = "m1D_dRx.dat", status = 'unknown')
open (unit = 106, file = "m1D_dRy.dat", status = 'unknown')
open (unit = 107, file = "m1D_dRz.dat", status = 'unknown')

Rtip(1) = xscan
Rtip(2) = yscan
Rtip(3) = zmax
Rsond   = Rtip
call cpu_time(time_start)


!if (wrtDebug .gt. 2) then
!	open (unit = 200, file = "1D.xyz", status = 'unknown')
!end 


do iz = 1, nz
	Rtmp(:) = Rtip(:) - tip%Rs(:,1)                                  ! move tip to pos first atom to Rtip
	call tip%move( Rtmp )
	Etip = 0.0
	Ftip = 0.0
	call getFF_LJ  ( tip%Rs(:,1), tip%Zs(1), surf, Etip, Ftip )
	write (101,'(2E20.10)',advance='no') Rtip(3), Etip
	write (102,'(2E20.10)',advance='no') Rtip(3), Ftip(1)
	write (103,'(2E20.10)',advance='no') Rtip(3), Ftip(2)
	write (104,'(2E20.10)',advance='no') Rtip(3), Ftip(3)
	write (105,'(2E20.10)',advance='no') Rtip(3), tip%Rs(1,1)
	write (106,'(2E20.10)',advance='no') Rtip(3), tip%Rs(2,1)
	write (107,'(2E20.10)',advance='no') Rtip(3), tip%Rs(3,1)
	write (*,'(A,i5, 3f25.10)') " ======== iz, Rtip(3), tip%Rs(3,1), Rtmp(3) ",iz, Rtip(3), tip%Rs(3,1),Rtmp(3)
	do ipos = 1, npos	
		Rsond(:) = tip%Rs(:,1) + poslist(:,ipos)
		iiter = 0
		if (relaxMethod .gt. 0) then
			call relax( surf, Rtip,  Rsond, Fsond, Esond )  ! this is the importaint
		else
			!write (*,*) "  fixed "
			Fsond(:) = 0
			Esond    = 0
			call getFF_LJ  ( Rsond, sondZ, surf, Esond, Fsond )
		end if
		! if (wrtDebug .gt. 2) then
		!	write ( 200+ipos,'(i5)')   (1+tip%n + surf%n) 
		!	write ( 200+ipos,'(A,2i5)') "  iz, iteration ", iz,iiter
  		!	write ( 200+ipos, '( A, 3f20.8 )') atypes(sondZ)%symbol, Rsond
		!	call system2XYZ ( tip, 200+ipos)
		!	call system2XYZ ( surf, 200+ipos)
		! end if ! wrtDebug 
		write (*,'(A,2i8,3f25.10)') " ipos,iiter, Rsond(3), Esond, Fsond(3) ",ipos,iiter, Rsond(3), Esond, Fsond(3)
		write (101,'(E20.10)',advance='no') Esond
		write (102,'(E20.10)',advance='no') Fsond(1)
		write (103,'(E20.10)',advance='no') Fsond(2)
		write (104,'(E20.10)',advance='no') Fsond(3)
		write (105,'(E20.10)',advance='no') (Rsond(1) - Rtip(1)) 
		write (106,'(E20.10)',advance='no') (Rsond(1) - Rtip(1)) 
		write (107,'(E20.10)',advance='no') (Rsond(1) - Rtip(1)) 
	end do ! ipos
	write (101,*)
	write (102,*)
	write (103,*)
	write (104,*)
	write (105,*)
	write (106,*)
	write (107,*)
	Rtip(3) = Rtip(3) - zstep
end do ! iz
call cpu_time(time_end)
write (*,'(A,f10.5,A)') " >>  .... done in  ", (time_end-time_start) ,"[sec]"
write (*,'(A,f10.5,A)') " >>  = ", (time_end-time_start)/nz,"[sec] per tip step "


 close(101) 
 close(102) 
 close(103) 
 close(104) 
 close(105)
 close(106)
 close(107)

deallocate( poslist )

stop

end program SHTM_1D
