
program SHTM_3D
    use G_globals
  implicit none

! == Local Parameters and Data Declaration
! == Local Variable Declaration and Description
integer ix,iy,iz,OutNtot

real Esond, Etip
real, dimension (3) :: Rsond, Fsond, Rtmp, Ftip

integer ipos,npos
real, dimension (:,:), allocatable :: poslist

real, dimension (3) :: a1,a2
real R1, T1,T2, TSS1, TSS2

real time_start,time_end
real time_start2,time_end2

real, dimension (3) :: eignums

type (grid3D)     :: OutE, OutFx, OutFy, OutFz, OutX, OutY, OutZ, OutT1,OutT2, OutTSS1, OutTSS2, OutEig1, OutEig2, OutEig3

! == Procedure

a1 = (/ 0,0,1 /)  ! orientation of pz orbitals
! beta = 1.0

! ==================================================
! =================== loading inputs
! ==================================================

write (*,*) " >> Reading SHTM.ini"
  open (unit = 69, file = "SHTM_3D.ini", status = 'old')
  read (69,*) wrtDebug
  read (69,*) format_Out
  read (69,*) relaxMethod, onGrid
  read (69,*) sampleOuside, FgridMax
  FgridMaxSq = FgridMax*FgridMax
  read (69,*) dt, convergF, damping, startKick, maxRelaxIter  
  read (69,*) kMorse 
  read (69,*) beta1, beta2
  read (69,*) kHarmonic
  read (69,*) RspringMin
  read (69,*) ddisp
  read (69,*) sondZ, Qsond
  read (69,*) OutE%step(:)
  read (69,*) OutE%Rmin(:)
  read (69,*) OutE%Rmax(:)
  close (69)

! ==================================================
! =================== initialization of LJ potiential
! ==================================================

  ! atomic parameters
write (*,*) " >> Read atomic positions and parameters "
call readspecies()
call surf%fromfile( 'surf.bas' )
call tip%fromfile ( 'tip.bas'  )

open (unit = 69, file = "poslist.ini", status = 'old')
	read (69,*) npos
	allocate( poslist(3,npos) )
	do ipos = 1,npos
		read (69,*) Rtmp(:)
		poslist(1,ipos) =  (  atypes( tip%Zs(1) )%R0 + atypes( SondZ )%R0  ) * Rtmp(1) * sin( 2*3.14159265359*Rtmp(2) ) * cos( 2*3.14159265359*Rtmp(3) )
		poslist(2,ipos) =  (  atypes( tip%Zs(1) )%R0 + atypes( SondZ )%R0  ) * Rtmp(1) * sin( 2*3.14159265359*Rtmp(2) ) * sin( 2*3.14159265359*Rtmp(3) )
		poslist(3,ipos) = -(  atypes( tip%Zs(1) )%R0 + atypes( SondZ )%R0  ) * Rtmp(1) * cos( 2*3.14159265359*Rtmp(2) )  
		if ( wrtDebug .gt. 0 ) write(*,'(A,i5,6f20.10)') " i, R,theta,phi, pos0 x,y,z: ", ipos,Rtmp(:), poslist(:,ipos)
	end do ! ipos

! ==================================================
! =================== creating GRID FORCE FIELD
! ==================================================

if ( onGrid .eq. 1 ) then
	write (*,*) ">> Loading Electrostatic Force ..."
	call FFgrid%fromXSF( "Felec" )
	write (*,*) ">> Set froce field strength..."
	FFgrid%f(:,:,:,:)  = FFgrid%f(:,:,:,:) * Qsond
	!call FFgrid%copySetup( Felec )
	!call FFgrid%echoSetup( )
	write (*,*) ">> Sampling surface force field ..."
	!FFgrid%f(:,:,:,:) = 0.0D0
	!FFgrid%f(:,:,:,:) = Felec%f(:,:,:,:)
	call cpu_time(time_start2)
	call sampleSurf( 1.D0, surf, FFgrid )
	call cpu_time(time_end2)
	write (*,'(A,f20.10)') " time(sampleSurf) total     [sec] : ", (time_end2-time_start2) 
	write (*,'(A,f20.10)') " time(sampleSurf) per_pixel [sec] : ", (time_end2-time_start2)/( FFgrid%N(1)*FFgrid%N(2)*FFgrid%N(3)  )
	write (*,*) ">> writing Electrostatic Force ..."
	call FFgrid%writeXSF( "FFgrid" )
else
	write (*,*) ">> Loading Electrostatic Force ..."
	call Felec%fromXSF( "Felec" )
	write (*,*) ">> Set froce field strength..."
	Felec%f(:,:,:,:)  = Felec%f(:,:,:,:) * Qsond
end if



! ==================================================
! =================== creating output grids
! ==================================================

write (*,*) " >> Initialize Grids over Tip position "
  call OutE%initgrid()
  call OutE%echoSetup()
  call OutFx%copySetup(OutE)
  call OutFy%copySetup(OutE)
  call OutFz%copySetup(OutE)
  call OutX%copySetup(OutE)
  call OutY%copySetup(OutE)
  call OutZ%copySetup(OutE)
  call OutT1%copySetup(OutE)
  call OutT2%copySetup(OutE)
  call OutTSS1%copySetup(OutE)
  call OutTSS2%copySetup(OutE)
  call OutEig1%copySetup(OutE)
  call OutEig2%copySetup(OutE)
  call OutEig3%copySetup(OutE)
  OutNtot = OutE%N(1)*OutE%N(2)*OutE%N(3) 

! ==================================================
! =================== main loop
! ==================================================

Rsond0(:) = 0
Rsond0(3) =  - ( atypes( tip%Zs(1) )%R0 + atypes( SondZ )%R0 )
write (*,'(A,3f20.5)')  " Rsond0 normalized :   ",  Rsond0 

write (*,*) " >> TIP sampling .... "
    !  OutE %f = 0
      OutFx%f = 0
      OutFy%f = 0
      OutFz%f = 0
      OutX%f = 0
      OutY%f = 0
      OutZ%f = 0
      OutT1%f = 0
      OutT2%f = 0
      OutTSS1%f = 0
      OutTSS2%f = 0
      OutEig1%f = 0
      OutEig2%f = 0
      OutEig3%f   = 0


! performance measurements
call cpu_time(time_start2)
relaxItersSum = 0


Rtip(1) = OutE%Rmin(1) ! Warrning - Rtip is global variable 
do ix = 1, OutE%N(1)
	Rtip(2) = OutE%Rmin(2)
	do iy = 1, OutE%N(2)
		Rtmp(:) = Rtip(:) - tip%Rs(:,1)                                  ! move tip to pos first atom to Rtip
		call tip%move( Rtmp )
		Rsond(:) = tip%Rs(:,1) + Rsond0
		write (*,'(A,2i5)') " ix, iy   ",ix,iy 
    	do iz = 1, OutE%N(3)
			Rtmp(:) = Rtip(:) - tip%Rs(:,1)                                  ! move tip to pos first atom to Rtip
			call tip%move( Rtmp )
			iiter = 0
			! Etip = 0.0
			! Ftip = 0.0
			! call getFF_LJ  ( tip%Rs(:,1), tip%Zs(1), surf, Etip, Ftip )   ! direct TipSurface Interaction
			Fsond(:) = 0
			Esond    = 0
		!	write (*,*) "DEBUG 0"
			if (relaxMethod .gt. 0) then
				if ( onGrid .eq. 1 ) then
					call relaxGrid( surf, Rsond, Fsond, Esond  )
				else
					call getFF_LJ       ( Rsond, sondZ, surf, Esond, Fsond)  ! Surface potential
					!call getFF_LJ       ( Rsond, sondZ,    tip, Esond, Fsond)  ! Tip poteitnal
					if (Esond .gt. 0) then
						do ipos = 1,npos
							Rsond(:) = tip%Rs(:,1) + poslist(:,ipos)
							Fsond(:) = 0
							Esond    = 0
							call getFF_LJ       ( Rsond, sondZ, surf, Esond, Fsond)  ! Surface potential
							call getFF_LJ       ( Rsond, sondZ,  tip, Esond, Fsond)  ! Tip poteitnal
							if (Esond .lt. 0) exit
						end do! ipos
					end if ! Esond
					call relax    ( surf, Rsond, Fsond, Esond )  
				end if ! onGrid
			else
				!write (*,*) "  fixed "
				Rsond(:) = tip%Rs(:,1) + Rsond0(:)
				Fsond(:) = 0
				Esond    = 0
				call getFF_LJ  ( Rsond, sondZ, surf, Esond, Fsond )
                call Felec%interpolate( Rsond, Fsond )
			end if
		!	a2(:) = Rsond(:) - tip%Rs(:,1)
		!	R1 = sqrt(dot_product(a2,a2))
		!	a2(:) = a2(:)/R1
		!	write (*,*) "DEBUG 1"
			call getHoppingPP ( beta1, Rsond, a1, a2,  tip, T1 )
			call getHoppingPP ( beta2, Rsond, a1, a2,  surf, T2 )
			call getHoppingSS ( beta1, Rsond, tip, TSS1 )
			call getHoppingSS ( beta2, Rsond, surf, TSS2 )
		!	write (*,*) "DEBUG 2"
			if (onGrid) then
				call  dynmatGrid ( surf, Rsond, eignums )
			else
				call  dynmat     ( surf, Rsond, eignums )
			end if
		!	write (*,*) "DEBUG 3"
			if (wrtDebug .gt. 0) write (*,'(A,4i5,4f25.10)') " ix,iy,iz,iters,E,Fz,RzTip,RzSond ",ix,iy,iz, iiter, Rtip(3), Rsond(3), Esond, Fsond(3)
      	!	OutE %f(ix,iy,iz)   = Esond
      		OutFx%f(ix,iy,iz)   = Fsond(1)
      		OutFy%f(ix,iy,iz)   = Fsond(2)
      		OutFz%f(ix,iy,iz)   = Fsond(3)
      		OutX%f(ix,iy,iz)    = Rsond(1)-Rtip(1)
      		OutY%f(ix,iy,iz)    = Rsond(2)-Rtip(2)
      		OutZ%f(ix,iy,iz)    = Rsond(3)-Rtip(3)
      		OutT1%f(ix,iy,iz)   = T1
      		OutT2%f(ix,iy,iz)   = T2
      		OutTSS1%f(ix,iy,iz) = TSS1
			OutTSS2%f(ix,iy,iz) = TSS2
      		OutEig1%f(ix,iy,iz) = eignums(1)
			OutEig2%f(ix,iy,iz) = eignums(2)
			OutEig3%f(ix,iy,iz) = eignums(3)
			Rtip(3) = Rtip(3) - OutE%step(3)
		end do ! iz
		Rtip(2) = Rtip(2) + OutE%step(2)
		Rtip(3) = OutE%Rmax(3)
    end do ! iy
	Rtip(1) = Rtip(1) + OutE%step(1)
end do ! ix

call cpu_time(time_end2)
 close(70) 
 close(71) 
write (*,'(A,i10)'    ) " number of tip positions (grid points) : ", ( OutNtot )
write (*,'(A,i10)'    ) " Relaxation Iterations ( total )       : ", ( relaxItersSum )
write (*,'(A,f16.8)'  ) " Relaxation Iterations ( per tip pos ) : ", ( relaxItersSum/real(OutNtot) )
write (*,'(A,f16.8,A)') " CPU_time ( total )        [sec]       : ", (time_end2-time_start2) 
write (*,'(A,f16.8,A)') " CPU_time ( per tip pos )  [sec]       : ", (time_end2-time_start2)/OutNtot

!call OutE %output("OutE" ,format_Out,1.0)
call OutFx%output ("OutFx",format_Out,1.0)
call OutFy%output ("OutFy",format_Out,1.0)
call OutFz%output ("OutFz",format_Out,1.0)
call OutX%output  ("OutX",format_Out,1.0)
call OutY%output  ("OutY",format_Out,1.0)
call OutZ%output  ("OutZ",format_Out,1.0)

call OutT1%output  ("OutT1",format_Out,1.0)
call OutT2%output  ("OutT2",format_Out,1.0)
call OutTSS1%output("OutTSS1",format_Out,1.0)
call OutTSS2%output("OutTSS2",format_Out,1.0)

call OutEig1%output("OutEig1",format_Out,1.0)
call OutEig2%output("OutEig2",format_Out,1.0)
call OutEig3%output("OutEig3",format_Out,1.0)

stop

end program SHTM_3D
