import processing.opengl.*;
import codeanticode.glgraphics.*;

PImage img;
GLTexture srcTex, destTex;
GLTextureFilter myFilter,cp;

float mouseDist = 50.0;

void setup()
{
  size(800, 600, GLConstants.GLGRAPHICS);
  img = loadImage("test.jpg");
  cp = new GLTextureFilter(this, "copy.xml"); // copy source texture to destination texture
  myFilter = new GLTextureFilter(this, "MouseHole.xml"); // makes hole arround mouse
  srcTex = new GLTexture(this);  destTex = new GLTexture(this);
  srcTex.putPixelsIntoTexture(img);   destTex.putPixelsIntoTexture(img);
}

void draw()
{
  // background to see Transparecy
 background(255,255);
 stroke(0,255,0,255);
 for(int i=0;i<width;i+=10){
 line(i,0,i,height);
 };
    
    //mouse erraser
    float x = map(mouseX, 0, width, 0, srcTex.width);
    float y = map(mouseY, 0, height, 0, srcTex.height);
    myFilter.setParameterValue("mpos", new float[]{x, y});
    myFilter.setParameterValue("mdist", mouseDist);
    myFilter.apply(srcTex, destTex);
    
    //visualize 
    image(destTex, 0, 0, width, height); 
    
    //copy it back
    cp.apply(destTex, srcTex);   

}
