#!/usr/bin/python

import Element
import math

def loadBas(name):
	xyzs = []
	f = open(name,"r")
	while True:
		n=0;
		l = f.readline()
		#print "--",l,"--"
		try:
			n=int(l)
		except ValueError:
			break
		if (n>0):
			n=int(l)
			#f.readline()
			e=[];x=[];y=[]; z=[];
			for i in xrange(n):
				l=f.readline().split()
				#print l
				e.append( int(l[0]) )
	   			x.append( float(l[1]) )
	   			y.append( float(l[2]) )
	   			z.append( float(l[3]) )
			xyzs.append( [e,x,y,z] )
		else:
			break
		f.readline()
	f.close()
	return xyzs

def findBonds( xyz, sc ):
	bonds = []
	n = len(xyz[0])
	for i in xrange(n):
		for j in xrange(i):
			dx=xyz[1][j]-xyz[1][i]
			dy=xyz[2][j]-xyz[2][i]
			dz=xyz[3][j]-xyz[3][i]
			r=math.sqrt(dx*dx+dy*dy+dz*dz)
			bondlength=Element.rad[xyz[0][i]-1]+ Element.rad[xyz[0][j]-1]
			if (r<( sc * bondlength)) :
				bonds.append([i,j])
	return bonds

def findBondsSimple( xyz, rmax ):
	bonds = []
	n = len(xyz[0])
	for i in xrange(n):
		for j in xrange(i):
			dx=xyz[1][j]-xyz[1][i]
			dy=xyz[2][j]-xyz[2][i]
			dz=xyz[3][j]-xyz[3][i]
			r=math.sqrt(dx*dx+dy*dy+dz*dz)
			if (r<rmax) :
				bonds.append([i,j])
	return bonds
