
from pylab import *
from matplotlib.colors import LinearSegmentedColormap
import Element 

# ======== Force to Frequency shift

def derivate( F  ):
	dim=shape(F)
	dF = zeros( (dim[0]-1,dim[1],dim[2]) )
	dF =  F[1:,:,:] - F[:-1,:,:]
	return dF

def DeSader( F ):
	dim=shape(F)
	dF = zeros( (dim[0]-3,dim[1],dim[2]) )
	print shape(  F )
	print shape( dF ) 
	dF[:,:,:] = ( -0.866*F[:-3,:,:] - 0.134*F[1:-2,:,:] + 0.134*F[2:-1,:,:] + 0.866*F[3:,:,:] )/2
	return dF

def smooth( F, n):
	for i in range(1):
		F[1:-1,:,:] = (F[2:,:,:] + 2*F[1:-1,:,:] +  F[:-2,:,:])/4  
	return F

def F2df( F, dz = 0.1, k0 = 1800.0, f0=30300.0 ):
	df2K = 2.0*k0/f0 
	F  *= 16.0217656            # to N/m
	dF = DeSader(F)/df2K/dz     # to [Hz]
	return dF

# ======== lateral deviatin Points

def slice2scatter(Xs,Ys, extent):
	nx = len(Xs)
	ny = len(Xs[0])
	Ps = mgrid[0:nx,0:ny].astype(float)
	Ps[0] *= ((extent[1]-extent[0])/float(nx))
	Ps[1] *= ((extent[3]-extent[2])/float(ny))
	Ps[0] += extent[0] + Ys
	Ps[1] += extent[2] + Xs
	return Ps

def plotBonds( xyz, bonds ):
	for b in bonds:
		i=b[0]; j=b[1]
		arrow(xyz[1][i], xyz[2][i], xyz[1][j]-xyz[1][i], xyz[2][j]-xyz[2][i], head_width=0.0, head_length=0.0,  fc='k', ec='k', lw= 1.0,ls='solid' )

def plotGeom( atoms=None, bonds=None):
	if atoms is not None:
		scatter( atoms[1], atoms[2], s=sqrt(atoms[0])*10,   c='#FFFFFF'  )
	if bonds is not None:
		plotBonds( atoms, bonds )	

def colorize_XY2RG(Xs, Ys, l=0.5 ):
	r = sqrt(Xs**2 + Ys**2)
	vmax = r[5:-5,5:-5].max()
	Red   = 0.5*Xs/vmax + 0.5
	Green = 0.5*Ys/vmax + 0.5
	c = array( (Red, Green, zeros(shape(Red)) )  )  # -->  array of (3,n,m) shape, but need (n,m,3)
	c = c.swapaxes(0,2) 
	c = c.swapaxes(0,1) 
	return c, vmax

# ======== plots

def plotPositiveNegative( F, ilist, extent, dz = 0.1,  atoms=None, bonds=None, withcolorbar=False, bd=1 ):
	cdict2 = {	'red':   ( (0.0, 1.0, 1.0), (0.25, 1.0, 1.0),  (0.5, 1.0, 1.0), (0.75, 0.0, 0.0), (1.0, 0.0, 0.0)   ),
				'green': ( (0.0, 0.0, 0.0), (0.25, 1.0, 1.0),  (0.5, 1.0, 1.0), (0.75, 1.0, 1.0), (1.0, 0.0, 0.0)   ),
				'blue':  ( (0.0, 0.0, 0.0), (0.25, 0.0, 0.0),  (0.5, 1.0, 1.0), (0.75, 1.0, 1.0), (1.0, 1.0, 1.0)   )    }
	cdict3 = {	'red':   ( (0.0, 1.0, 1.0), (0.25, 1.0, 1.0),  (0.5, 0.0, 0.0), (0.75, 0.0, 0.0), (1.0, 0.0, 0.0)   ),
				'green': ( (0.0, 1.0, 1.0), (0.25, 0.0, 0.0),  (0.5, 0.0, 0.0), (0.75, 0.0, 0.0), (1.0, 1.0, 1.0)   ),
				'blue':  ( (0.0, 0.0, 0.0), (0.25, 0.0, 0.0),  (0.5, 0.0, 0.0), (0.75, 1.0, 1.0), (1.0, 1.0, 1.0)   )    }
	cmap = LinearSegmentedColormap('BlueRed1', cdict2)
	n=len(ilist)
	fig = figure( figsize=(3*n,0.5+3 ) );
	for i in range(n):
		ii = ilist[i]
		vmin = F[ii,bd:-bd,bd:-bd].min(); vmax = F[ii,bd:-bd,bd:-bd].max();  
		print " i,vmin,vmax ",i,vmin,vmax
		vmax = max( -vmin, vmax ); vmin=-vmax
		subplot(1,n,i+1);
		title( "z=%2.2f$\AA$" %(dz*ii)  );
		imshow( F[ii],  extent=extent,  origin='image', interpolation='bicubic', cmap=cmap, vmin=vmin, vmax=vmax  ) 
		if withcolorbar:
			colorbar()
		plotGeom( atoms, bonds)
		xlim(extent[0],extent[1])
		ylim(extent[2],extent[3])
	#savefig( fname+'_all.png', bbox_inches='tight', pad_inches=0)
	return fig

def plotWithAtoms( F, ilist, extent, dz = 0.1,  atoms=None, bonds=None, cmap = 'gray', withcolorbar=False, vmin=None, vmax=None, bd=1 ):
	fixVmin=True; fixVmax=True
	if vmin is None:
		fixVmin=False
	if vmax is None:
		fixVmax=False	
	n=len(ilist)
	fig = figure( figsize=(3*n,0.5+3 ) )
	for i in range(n):
		ii = ilist[i]
		if not fixVmin:
			vmin=F[ii,bd:-bd,bd:-bd].min()
		if not fixVmax: 
			vmax=F[ii,bd:-bd,bd:-bd].max()
		#print " i,vmin,vmax ",i,vmin,vmax
		subplot(1,n,i+1);
		title( "z=%2.2f$\AA$" %(dz*ii)  );
		imshow( F[ii],  extent=extent,  origin='image', interpolation='bicubic', cmap=cmap, vmin=vmin, vmax=vmax  ) 
		if withcolorbar:
			colorbar()
		plotGeom( atoms, bonds)
		xlim(extent[0],extent[1])
		ylim(extent[2],extent[3])
		#ax = plt.gca()
		#ax.set_axis_off()
	#savefig( fname+'_all.png', bbox_inches='tight', pad_inches=0)
	return fig

def plotDeviations_RG( Xs, Ys, ilist, extent, dz = 0.1,  atoms=None, bonds=None, cmap = 'gray' ):
	n=len(ilist)
	fig = figure( figsize=(3*n,0.5+3 ) )
	for i in range(n):
		ii = ilist[i]
		subplot(1,n,i+1);
		title( "z=%2.2f$\AA$" %(dz*ii)  );
		HSBs,vmax = colorize_XY2RG(Xs[ii],Ys[ii])
		#print i,ii,vmax
		imshow( HSBs,  extent=extent, vmin=0, vmax=vmax,  origin='image' ) 
		plotGeom( atoms, bonds)
		xlim(extent[0],extent[1])
		ylim(extent[2],extent[3])
	#savefig( 'dcomplex_RG_all.png', bbox_inches='tight', pad_inches=0)
	return fig

def plotDeviations_Points( Xs,Ys, ilist, extent, dz = 0.1,  atoms=None, bonds=None, alpha=0.25, step=None, c='#FF0000', s=1 ):
	n=len(ilist)
	fig = figure( figsize=(3*n,0.5+3 ) )	
	for i in range(n):
		ii = ilist[i]
		#print i,ii
		subplot(1,n,i+1);
		title( "z=%2.2f$\AA$" %(dz*ii)  );
		imshow( Xs[ii]*0,  extent=extent,  origin='image', cmap = 'binary' ) 
		Ps = slice2scatter(Xs[ii],Ys[ii], extent)
		if step is None:
			scatter( Ps[1].flat, Ps[0].flat, s=s,  c=c, edgecolors='none', alpha=alpha  )
		else:
			scatter( Ps[1,::step,::step].flat, Ps[0,::step,::step].flat, s=s,  c=c, edgecolors='none', alpha=alpha  )
		plotGeom( atoms, bonds)
		xlim(extent[0],extent[1])
		ylim(extent[2],extent[3])
	#savefig( 'points2_all.png', bbox_inches='tight', pad_inches=0)
	return fig


