#!/usr/bin/python

from pylab import *

hbar = 6.5821192815e-16      # eV.s ... reduced planck mass
atomic_mass = 1.66053892e-27 # kg/atomic unit
eVA2_to_Nm = 16.0217657
toSI = eVA2_to_Nm / atomic_mass 


Motal_Mass  = 15.9994 * 1.3   # atomic units
stiffness   = 0.1   # eV/A^2
print " stiffness = ",eVA2_to_Nm*stiffness, '[ N/m ]'

f0 = sqrt( toSI * stiffness / Motal_Mass )    # [Hz]

print " frequency = ", f0 *1e-12        , '[ THz ]'
print " Energy    = ", 0.5*hbar*f0*1000 , '[ meV ]'
