#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap
import matplotlib.colors as mcolors
import matplotlib.cm as cmx

# ========== Settings

bd    =  1
shift =  11

#ilist = [ 40,42,44,46,48,50  ]
#ilist = [ 40,41,42,43,44,45,46  ]
#xslice = 4.0

#ilist = [ 35,36,37,38,39,40,41,42,43,44,45,46  ]

#ilist = [ 35,36,37,38,39,40,41,42,43,44,45  ]

#ilist  = [ 35,36,37,38,39,40,41,42,43 ]
#ilist  = range(40,50)
#ilist = [48]

ilist = [44,46,48,50,52,54]
#ilist = range(50,54)

#ilist = [ 36,38,40,42,44,46  ]

xslice = 0.0

yzoom = 1.5
xlims = [-11,11]
ylims = [1.0,3.0]

lw = 1.5

# =========== functions

def k2e( k, Motal_Mass = 15.9994 ):
	hbar = 6.5821192815e-16      # eV.s ... reduced planck mass
	atomic_mass = 1.66053892e-27 # kg/atomic unit
	eVA2_to_Nm = 16.0217657
	f = sqrt( k * ( eVA2_to_Nm / ( atomic_mass * Motal_Mass ) )   ) 
	return 0.5*hbar*f*1000

def makeColorSeq( ilist, cmap='jet' ):
	cm = plt.get_cmap(cmap) 
	cNorm  = mcolors.Normalize( vmin=ilist[0], vmax=ilist[-1] )
	scalarMap = cmx.ScalarMappable(norm=cNorm, cmap=cm)
	colors = []
	for i in range(len(ilist)):
		colors.append( scalarMap.to_rgba(ilist[i]) )
	return colors

def plotLineProfilesY(F,yslice,ilist,lvec,nDim, bd=None, colors=None, xlims=None, ylims=None, yzoom=1, lw=1, withlegend = False ):
	xs = array(range(nDim[1] ))*lvec[2,1]/nDim[1] + lvec[0,1]
	xs = xs[::-1]
	for i in range(len(ilist)):
		iz = ilist[i]
		iy = int(round( nDim[2]*(yslice-lvec[0,0])/lvec[1,0]  ))
		Fline = F[iz,iy,:]
		#if bd is None:
		#	Fmin = min(Fmin, Fline.min())
		#else:
		#	Fmin = min(Fmin, Fline[bd:-bd].min())			
		#print shape(Fline),shape(xs)
		dz=0.1
		#label="%1.1f$\AA$" %( 7.7 - iz*dz  )
		label="%1.1f$\AA$" %( iz*dz  )
		if colors is not None:
			plot(xs, Fline,   label=label, color=colors[i], lw=lw )
		else:
			plot(xs, Fline,   label=label, lw=lw )
	axhline(0,ls='--',color='k')
	if withlegend:
		legend()
	if ylims is not None:
		ylim(ylims[0],ylims[1])
	if xlims is not None:
		xlim(xlims[0],xlims[1])


# =========== prepare everything

extent=( -shift, shift , -shift, shift  )
atoms = loadBas('../surf.bas')[0]

colors = makeColorSeq( ilist )

print colors




# =========== Plot individaul datafiles

# CO vibration frequency  http://www.chem.qmul.ac.uk/surfaces/scc/scat5_4.htm
#      metal-carbon stretching mode (ca. 400  cm-1 )    50 meV
#      C-O                          (va. 2000 cm-1 )   250 meV


figure(figsize=(5,5))
E,lvec, nDim, head = loadXSF('OutEig1.xsf')
E = k2e( transpose(E,(0,2,1) ) )  # in [meV]
#E = transpose(E,(0,2,1) )          # in eV/A^2
lvec[0,0] = -shift; lvec[0,1] = -shift 
plotLineProfilesY(E,xslice,ilist,lvec,nDim, colors=colors, yzoom=yzoom, lw=lw, xlims=xlims, ylims=ylims )
savefig('Eig1_lineProfiles.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
E,lvec, nDim, head = loadXSF('OutEig2.xsf')
E = k2e( transpose(E,(0,2,1) ) )  # in [meV]
#E = transpose(E,(0,2,1) )          # in eV/A^2
lvec[0,0] = -shift; lvec[0,1] = -shift 
plotLineProfilesY(E,xslice,ilist,lvec,nDim, colors=colors, yzoom=yzoom, lw=lw, xlims=xlims, ylims=ylims )
savefig('Eig2_lineProfiles.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
E,lvec, nDim, head = loadXSF('OutEig3.xsf')
E = k2e( transpose(E,(0,2,1) ) )  # in [meV]
#E = transpose(E,(0,2,1) )          # in eV/A^2
lvec[0,0] = -shift; lvec[0,1] = -shift 
plotLineProfilesY(E,xslice,ilist,lvec,nDim, colors=colors, yzoom=yzoom, lw=lw, xlims=xlims )
savefig('Eig3_lineProfiles.png',     bbox_inches='tight', pad_inches=0 )
legend()
savefig('Eig3_lineProfiles_legend.png',     bbox_inches='tight', pad_inches=0 )

show()


