#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap

# ========== Settings

yzoom = 1.25
#xlims = [7,12]
#xlims = [7,10]
xlims = [5.0,11]

flims  = [-0.15,0.20]
dflims = [-15,15] 

#vlines=[8.1,7.6,7.3] # CO k0.01
#vlines=[7.9,7.4,7.1] # CO k0.03
vlines=None # CO k0.03

lw = 1.5

# =========== functions

def plotLines(F,xs,poss,lvec,nDim, bd=None, names=None, colors=None, xlims=None, ylims=None, vlines=None, hlines=None, yzoom=1, lw=1 ):
	Fmin = float("inf")
	linedata = zeros( (len(poss)+1,len(F)) )
	linedata[0,:] = xs
	for i in range(len(poss)):
		pos = poss[i]
		if names is not None:
			name=names[i]
		ix = int(round( nDim[1]*(pos[0]-lvec[0,0])/lvec[1,0]  ))
		iy = int(round( nDim[2]*(pos[1]-lvec[0,1])/lvec[2,1]  ))
		#print ix,iy
		Fline = F[:,iy,ix]
		if bd is None:
			Fmin = min(Fmin, Fline.min())
		else:
			Fmin = min(Fmin, Fline[bd:-bd].min())			
		#print shape(Fline),shape(xs)
		linedata[i+1,:] = Fline
		if colors is not None:
			plot(xs, Fline,   label=name, color=colors[i], lw=lw )
		else:
			plot(xs, Fline,   label=name, lw=lw )
	if hlines is not None:
		for xx in hlines:
			axhline(xx,ls='--',color='k')
	if vlines is not None:
		for xx in vlines:
			axvline(xx,ls='--',color='k')
	#legend()
	if ylims is None:
		ylim(Fmin*yzoom,-Fmin*yzoom)
	elif ylims == 'auto':
		pass
	else:
		ylim(ylims[0],ylims[1])	
	if xlim is not None:
		xlim(xlims[0],xlims[1])
	return linedata

def getPos( atoms, alist ):
	poss = []
	for i in alist:
		if isinstance( i, int ):
			a = [ atoms[1][i-1], atoms[2][i-1] ]
			poss.append( array( a ))
		else:
			a = array([ atoms[1][i[0]-1], atoms[2][i[0]-1] ])
			b = array([ atoms[1][i[1]-1], atoms[2][i[1]-1] ])
			poss.append( 0.5*(a+b) )
	return poss

# =========== prepare everything

extent=( -shift, shift , -shift, shift  )
atoms = loadBas('../surf.bas')[0]

#print atoms


# for NCDI
#alist = [ [32,35], [32,38], [96,5],[14,5],[96,90] ]
#names = [ 'ring', 'Cbond', 'Hbond', 'void','Hvoid' ]
#colors = ['#ff0000','#00ee00','#0000ff','#ff00ff','#008080' ]

# for PTCDA Au111
#alist = [ [163,158], [168,163], [189,106], [189,107], [106,143] ]
#names = [ 'ring', 'C-bond', 'H-bond', 'H-void', 'void' ]
#colors = ['#ff0000','#00ee00','#0000ff','#00C0C0','#ff00ff' ]

# for PTCDA Au111
#alist = [ [163,158], 163, [189,106], [189,107], [106,143] ]
#names = [ 'ring', 'C-atom', 'H-bond', 'H-void', 'void' ]
#colors = ['#ff0000','#00ee00','#0000ff','#00C0C0','#ff00ff' ]

# for PTCDA Au111
#alist = [ [163,158], 163, 163, [189,106], [189,107], [106,143] ]
#names = [ 'ring', 'C-atom', 'C-shift', 'H-bond', 'H-void', 'void' ]
#colors = ['#ff0000','#00ee00','#008800','#0000ff','#00C0C0','#ff00ff' ]


#Cu2N
shift =  6
alist = [ 88,103, [87,103], [87,88] ]
names = [ 'N', 'Cu', 'bond', 'void' ]
colors = ['#00ee00','#ff0000','#ffee00','#000000' ]


poss = getPos( atoms, alist )

poss[ 2 ]+=array([-0.1,0.1]) 

print "pos = ",poss


# =========== Plot individaul datafiles

figure(figsize=(5,5))
E,lvec, nDim, head = loadXSF('OutE.xsf')
xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]
E[:] = E[:] - E[0]
lvec[0,0] = -shift; lvec[0,1] = -shift 
linedata = plotLines(E,xs,poss,lvec,nDim, names=names, colors=colors, xlims=xlims, lw=lw, hlines=[0], vlines=vlines, yzoom=yzoom )
savetxt( 'E1D.dat', transpose(linedata) )
savefig('E1D.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
Fz,lvec, nDim, head = loadXSF('OutFz.xsf')
lvec[0,0] = -shift; lvec[0,1] = -shift 
linedata = plotLines(Fz*1.60217657,xs,poss,lvec,nDim, names=names, colors=colors,  xlims=xlims, lw=lw, hlines=[0], vlines=vlines, ylims=flims )
savetxt( 'Fz1D.dat', transpose(linedata) );
savefig('Fz1D.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
dFz = F2df( Fz, dz = 0.1, k0 = 1800.0, f0=30300.0 )
print shape(dFz),shape(xs)
xsdf =  0.5*(xs[2:-1]+xs[1:-2])
linedata = plotLines(dFz,xsdf,poss,lvec,nDim,bd=10, names=names, colors=colors,  xlims=xlims, lw=lw, hlines=[0], vlines=vlines, ylims=dflims )
savetxt( 'dF1D.dat', transpose(linedata) );
savefig('df1D.png',     bbox_inches='tight', pad_inches=0 )

'''
figure(figsize=(5,5))
T,lvec, nDim, head = loadXSF('OutT1.xsf')
xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]
lvec[0,0] = -shift; lvec[0,1] = -shift 
linedata = plotLines(T,xs,poss,lvec,nDim, names=names, colors=colors, yzoom=yzoom, ylims='auto', xlims=xlims, lw=lw, hlines=[0], vlines=vlines )
savetxt( 'T1pp_1D.dat', transpose(linedata) )
savefig('T1pp_1D.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
T,lvec, nDim, head = loadXSF('OutTSS1.xsf')
xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]
lvec[0,0] = -shift; lvec[0,1] = -shift 
linedata = plotLines(T,xs,poss,lvec,nDim, names=names, colors=colors, yzoom=yzoom, ylims='auto', xlims=xlims, lw=lw, hlines=[0], vlines=vlines )
savetxt( 'T1ss_1D.dat', transpose(linedata) );
savefig('T1ss_1D.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
T,lvec, nDim, head = loadXSF('OutT2.xsf')
xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]
lvec[0,0] = -shift; lvec[0,1] = -shift 
linedata = plotLines(T,xs,poss,lvec,nDim, names=names, colors=colors, yzoom=yzoom, ylims='auto', xlims=xlims, lw=lw, hlines=[0], vlines=vlines )
savetxt( 'T2pp_1D.dat',  transpose(linedata) )
savefig('T2pp_1D.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
T,lvec, nDim, head = loadXSF('OutTSS2.xsf')
xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]
lvec[0,0] = -shift; lvec[0,1] = -shift 
linedata = plotLines(T,xs,poss,lvec,nDim, names=names, colors=colors, yzoom=yzoom, ylims='auto', xlims=xlims, lw=lw, hlines=[0], vlines=vlines )
savetxt( 'T2ss_1D.dat', transpose(linedata) );
savefig('T2ss_1D.png',     bbox_inches='tight', pad_inches=0 )
'''



show()

