#!/usr/bin/python

from pylab import *

def loadAndPlotSim(fname):
	dataF = transpose(genfromtxt( name+'/1D_F.dat', skip_header=1 ))
	dataE = transpose(genfromtxt( name+'/1D_E.dat', skip_header=1 ))
	xs = dataE[0]
	F  = dataF[3]*1.60217657
	E  = dataE[1] 
	subplot(121);  plot(xs, F ,'.-',label=name+'Sim');
	subplot(122);  plot(xs, E ,'.-',label=name+'Sim');

def loadAndPlotExp(name):
	data = transpose(genfromtxt( 'F_'+fname+'.dat', skip_header=1 ))
	xs = data[1];  dz = xs[1]-xs[0]
	F  = data[2]*1e+9
	E  = cumsum(F)*dz / 1.60217657; 
	subplot(121);  plot(xs, F ,'.-',label=name+'Exp');
	subplot(122);  plot(xs, E ,'.-',label=name+'Exp');



loadAndPlotExp('atom')
loadAndPlotExp('ring')
loadAndPlotSim('atom')
loadAndPlotSim('ring')

subplot(121); axhline( 0.0 ,linestyle ='--', color='k'); title( "F$_z$  [nN] "    ); legend()
subplot(122); axhline( 0.0 ,linestyle ='--', color='k'); title( "Energy [eV] " );  legend()

show()
