#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap

# ========== Settings

bd    =  30 
shift =  6

# =========== functions

def plotLines(F,xs,poss,lvec,nDim, bd=None ):
	Fmin = float("inf")
	for i in range(len(poss)):
		pos = poss[i]
		ix = int(round( nDim[1]*(pos[0]-lvec[0,0])/lvec[1,0]  ))
		iy = int(round( nDim[2]*(pos[1]-lvec[0,1])/lvec[2,1]  ))
		#print ix,iy
		Fline = F[:,ix,iy]
		if bd is None:
			Fmin = min(Fmin, Fline.min())
		else:
			Fmin = min(Fmin, Fline[bd:-bd].min())			
		#print shape(Fline),shape(xs)
		plot(xs, Fline,   label=names[i] )
	axhline(0,ls='--')
	legend()
	ylim(Fmin,-Fmin)

# =========== prepare everything

extent=( -shift, shift , -shift, shift  )

# FormicAcid
bond = 0.5*( array([1.31977 ,-1.12556])+array([-1.27118,-1.12556])) 
poss  = [ [0,0], [ 1.31977, -1.12556], [-1.27118,-1.12556], [ 0.28585, -1.17139 ], bond ] 
names = [ 'hole'   ,     'O8'        ,         'O9'       ,        'H2'       ,              'HO'                                            ]

'''
# C5H5NO
bond = 0.5*( array([ -1.36960,    -1.17719 ])+array([ 0.39739,    -1.21995  ])) 
ring = 0.5*( array([4.24783,    -1.03610 ])+array([1.47862,    -1.17719 ]) ) 
poss  = [ [0,0], [ -1.36960,    -1.17719 ], [1.47862,    -1.17719 ], [ 0.39739,    -1.21995  ], bond, ring ] 
names = [ 'hole'   ,     'O8'        ,         'O9'       ,        'H2'       ,              'HO', 'ring'  ]
'''


# =========== Plot individaul datafiles

#Fz,lvec, nDim, head = loadXSF('OutFz.xsf')
Fz,lvec, nDim, head = loadXSF('OutE.xsf')
xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]

figure(figsize=(5,5))
E,lvec, nDim, head = loadXSF('OutE.xsf')
E[:] = E[:] - E[0]
lvec[0,0] = -shift; lvec[0,1] = -shift 
plotLines(E,xs,poss,lvec,nDim)
savefig('E1D.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
Fz,lvec, nDim, head = loadXSF('OutFz.xsf')
lvec[0,0] = -shift; lvec[0,1] = -shift 
plotLines(Fz,xs,poss,lvec,nDim)
savefig('Fz1D.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
dFz = F2df( Fz, dz = 0.1, k0 = 1800.0, f0=30300.0 )
print shape(dFz),shape(xs)
xsdf =  0.5*(xs[2:-1]+xs[1:-2])
plotLines(dFz,xsdf,poss,lvec,nDim,bd=5)
savefig('df1D.png',     bbox_inches='tight', pad_inches=0 )

show()
