#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap

# ========== Settings

bd    =  30 
shift =  6

# =========== functions

def getLine( F, nDim,lvec, pos):
	ix = int(round( nDim[1]*(pos[0]-lvec[0,0])/lvec[1,0]  ))
	iy = int(round( nDim[2]*(pos[1]-lvec[0,1])/lvec[2,1]  ))
	#print ix,iy
	Fline = F[:,iy,ix]
	return Fline

def appendLines( F, nDim, lvec, poss, lines ):
	for pos in poss:
		lines.append(getLine( F, nDim,lvec, pos))
	return lines

def plotLines( xs, lines, bd=None, names=None, colors=None, lss=None ):
	Fmin = float("inf")
	for i in range(len(lines)):
		Fline = lines[i]
		if lss is None:
			ls='-'
		else:
			ls=lss[i]
		if names is not None:
			name=names[i]
		if bd is None:
			Fmin = min(Fmin, Fline.min())
		else:
			Fmin = min(Fmin, Fline[bd:-bd].min())			
		#print shape(Fline),shape(xs)
		if colors is not None:
			plot(xs, Fline,   label=name, color=colors[i], ls=ls )
		else:
			plot(xs, Fline,   label=name, ls=ls )
	axhline(0,ls='--')
	legend()
	ylim(Fmin,-Fmin)

def getPos( atoms, alist ):
	poss = []
	for i in alist:
		if isinstance( i, int ):
			a = [ atoms[1][i-1], atoms[2][i-1] ]
			poss.append( array( a ))
		else:
			a = array([ atoms[1][i[0]-1], atoms[2][i[0]-1] ])
			b = array([ atoms[1][i[1]-1], atoms[2][i[1]-1] ])
			poss.append( 0.5*(a+b) )
	return poss

# =========== prepare everything

extent=( -shift, shift , -shift, shift  )
atoms = loadBas('surf.bas')[0]

#print atoms

#alist = [ [14,5], 96, 5, 81, [96,5], [32,38], [32,35] ]
#names = [ 'hole','O96','H5', 'N81', 'Hbond', '  '     ]

alist  = [ [96,5],[96,90] ]
names  = [ 'HbondRlx', 'HvoidRlx','HbondFix', 'HvoidFix' ]
colors = ['#0000ff','#008080','#0000ff','#008080' ]
lss    = ['-','-','--','--' ]

namesDiff  = ['Bond-VoidRlx','Bond-VoidFix','Rlx-FixVoid','Rlx-FixBond']
colorsDiff = ['r','r','#0000ff','#008080']
lssDiff    = ['-','--','-','-']


poss = getPos( atoms, alist )

print "pos = ",poss

# =========== Plot Energy

Erlx,lvec, nDim, head = loadXSF('3Drelaxed/OutE.xsf')
Efix,lvec, nDim, head = loadXSF('3Dfixed/OutE.xsf')
lvec[0,0] = -shift; lvec[0,1] = -shift 
xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]

Erlx[:] = Erlx[:] - Erlx[0]
Efix[:] = Efix[:] - Efix[0]

figure(figsize=(5,5))
Elines = []
appendLines( Erlx, nDim, lvec, poss, Elines )
appendLines( Efix, nDim, lvec, poss, Elines )
plotLines(xs,Elines, names=names, colors=colors, lss=lss); 
savefig('E1Dcomp.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
Ediffs = [ Elines[0]-Elines[1], Elines[2]-Elines[3], Elines[2]-Elines[0], Elines[3]-Elines[1] ]
plotLines( xs,Ediffs , names=namesDiff, colors=colorsDiff, lss=lssDiff  ); 
savefig('E1Ddiff.png',     bbox_inches='tight', pad_inches=0 )

# =========== Plot force

Frlx,lvec, nDim, head = loadXSF('3Drelaxed/OutFz.xsf')
Ffix,lvec, nDim, head = loadXSF('3Dfixed/OutFz.xsf')

lvec[0,0] = -shift; lvec[0,1] = -shift 
xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]

figure(figsize=(5,5))
Flines = []
appendLines( Frlx, nDim, lvec, poss, Flines )
appendLines( Ffix, nDim, lvec, poss, Flines )
plotLines(xs,Flines, names=names, colors=colors, lss=lss); 
savefig('F1Dcomp.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
Fdiffs = [ Flines[0]-Flines[1], Flines[2]-Flines[3], Flines[2]-Flines[0], Flines[3]-Flines[1] ]
plotLines( xs,Fdiffs , bd=10, names=namesDiff, colors=colorsDiff, lss=lssDiff  ); 
savefig('F1Ddiff.png',     bbox_inches='tight', pad_inches=0 )


# =========== Plot df

dFrlx = F2df( Frlx, dz = 0.1, k0 = 1800.0, f0=30300.0 )
dFfix = F2df( Ffix, dz = 0.1, k0 = 1800.0, f0=30300.0 )
xsdf =  0.5*(xs[2:-1]+xs[1:-2])

figure(figsize=(5,5))
dFlines = []
appendLines( dFrlx, nDim, lvec, poss, dFlines )
appendLines( dFfix, nDim, lvec, poss, dFlines )
plotLines(xsdf,dFlines, names=names, colors=colors, lss=lss); 
savefig('dF1Dcomp.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
dFdiffs = [ dFlines[0]-dFlines[1], dFlines[2]-dFlines[3], dFlines[2]-dFlines[0], dFlines[3]-dFlines[1] ]
plotLines( xsdf,dFdiffs , bd=10, names=namesDiff, colors=colorsDiff, lss=lssDiff  ); 
savefig('dF1Ddiff.png',     bbox_inches='tight', pad_inches=0 )


show()

