#!/usr/bin/python

from pylab import *

def loadAndPlotSim(name):
	dataF = transpose(genfromtxt( name+'/1D_F.dat', skip_header=1 ))
	dataE = transpose(genfromtxt( name+'/1D_E.dat', skip_header=1 ))
	xs = dataE[0]
	F  = dataF[3]*1.60217657
	E  = dataE[1] 
	subplot(121);  plot(xs, F ,'.-',label=name+'Sim')
	subplot(122);  plot(xs, E ,'.-',label=name+'Sim')
	return [xs,F]

def loadAndPlotExp(name, simData=None , xshift=0, Fshift=0, Eshift=0 ):
	data = transpose(genfromtxt( 'F_'+name+'.dat', skip_header=1 ))
	xs = data[1];  dz = xs[1]-xs[0]
	F  = data[2]*1e+9
	xs =  xs[-1] - xs
	if simData is not None:
		iminSim   = argmin(simData[1])
		iminExp   = argmin(F)
		xshift = simData[0][iminSim] - xs[iminExp]
	xs  = xs + xshift
	F  += Fshift
	E   = Eshift + cumsum(F)*dz / 1.60217657; 
	subplot(121);  plot(xs, F ,'.-',label=name+'Exp')
	subplot(122);  plot(xs, E ,'.-',label=name+'Exp')
	return xshift

ringSimData = loadAndPlotSim('ring')
xshift      = loadAndPlotExp('ring',simData=ringSimData)

loadAndPlotSim('atom')
loadAndPlotExp('atom',xshift=xshift)

subplot(121); axhline( 0.0 ,linestyle ='--', color='k'); title( "F$_z$  [nN] "    ); legend(); ylim(ringSimData[1].min()*1.3,-ringSimData[1].min()*1.3)
subplot(122); axhline( 0.0 ,linestyle ='--', color='k'); title( "Energy [eV] " );  legend()




savefig('AtomRing1D.png', bbox_inches='tight', pad_inches=0 )

show()
