#!/usr/bin/python

from pylab import *
import sys


xshift=float(sys.argv[1])

ExpAtom = transpose(genfromtxt( 'F_atom.dat', skip_header=1 ))
ExpRing = transpose(genfromtxt( 'F_ring.dat', skip_header=1 ))
SimAtom = transpose(genfromtxt( 'atom/1D_F.dat', skip_header=1 ))
SimRing = transpose(genfromtxt( 'ring/1D_F.dat', skip_header=1 ))

xsSim =  SimAtom[0]
xsExp =  ExpAtom[1,-1]- ExpAtom[1] + xshift
diffF_Sim = (SimAtom[3] - SimRing[3])*1.60217657
diffF_Exp = (ExpAtom[2] - ExpRing[2])*1e+9

#print xsSim
#print diffF_Sim
#print xsExp
#print diffF_Exp


plot( xsSim, diffF_Sim, label='Sim' )
plot( xsExp, diffF_Exp, label='Exp' )
axhline( 0.0 ,linestyle ='--', color='k'); 
title( "F$_z$  [nN] "    ); legend(); 

#Fmin = min( diffF_Exp.min(), diffF_Sim.min() )
#ylim(Fmin*1.3,-Fmin*1.3)

Fmax = diffF_Exp.max()
ylim(-Fmax*2.0,Fmax*2.0)

suptitle( 'xshift=%3.3f' %xshift )

savefig('AtomRing1D_Difference.png', bbox_inches='tight', pad_inches=0 )

show()
