#!/usr/bin/python

from pylab import *
import sys

A=float(sys.argv[1])
B=float(sys.argv[2])
xshift=float(sys.argv[3])



def loadAndPlotSim(name):
	dataF = transpose(genfromtxt( name+'/1D_F.dat', skip_header=1 ))
	dataE = transpose(genfromtxt( name+'/1D_E.dat', skip_header=1 ))
	xs = dataE[0]
	F  = dataF[3]*1.60217657
	E  = dataE[1] 
	subplot(121);  plot(xs, F ,'.-',label=name+'Sim')
	subplot(122);  plot(xs, E ,'.-',label=name+'Sim')
	return [xs,F]

def loadAndPlotExp(name, simData=None , xshift=0, Fshift=0, Eshift=0, A=0, B=0 ):
	data = transpose(genfromtxt( 'F_'+name+'.dat', skip_header=1 ))
	xs = data[1];  dz = xs[1]-xs[0]
	F  = data[2]*1e+9 + A + B*(xs-xs[0])
	xs =  xs[-1] - xs
	xs  = xs + xshift
	F  += Fshift
	E   = Eshift + cumsum(F)*dz / 1.60217657; 
	subplot(121);  plot(xs, F ,'.-',label=name+'Exp')
	subplot(122);  plot(xs, E ,'.-',label=name+'Exp')
	return xshift

ringSimData = loadAndPlotSim('ring')
loadAndPlotExp('ring',xshift=xshift, A=A, B=B)

loadAndPlotSim('atom')
loadAndPlotExp('atom',xshift=xshift,A=A,B=B)

subplot(121); axhline( 0.0 ,linestyle ='--', color='k'); title( "F$_z$  [nN] "    ); legend(); ylim(ringSimData[1].min()*1.3,-ringSimData[1].min()*1.3)
subplot(122); axhline( 0.0 ,linestyle ='--', color='k'); title( "Energy [eV] " );  legend()

suptitle( 'A=%3.3f B=%3.3f xshift=%3.3f' %(A,B,xshift) )




savefig('AtomRing1D_lin.png', bbox_inches='tight', pad_inches=0 )

show()
