#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap

# ========== Settings

#ilist =  [0,40,45,50,55]
#ilist =  [40,42,44,46,48,50]
ilist =  [40,41,42,43,44,45,46,47,48,49,50]
#ilist =  [35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50]
#ilist =  [5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80]
#ilist =  [45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60]
#ilist =  [50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70]

bd    =  30 
shift =  6


# =========== prepare everything

extent=( -shift, shift , -shift, shift  )

atoms = loadBas('../surf.bas')[0]
bonds = findBondsSimple(atoms, 1.7 ) 


# =========== Plot individaul datafiles


Fz,lvec, nDim, head = loadXSF('OutFz.xsf')
plotPositiveNegative( Fz, ilist, extent, dz = 0.1, atoms=atoms,  withcolorbar=True );            savefig('Fz_RB.png',     bbox_inches='tight', pad_inches=0 )


Fx,lvec, nDim, head = loadXSF('OutFx.xsf')
Fy,lvec, nDim, head = loadXSF('OutFy.xsf')


df_data = F2df( Fz, dz = 0.1, k0 = 1800.0, f0=30300.0 )
saveXSF('df.xsf', head, lvec, df_data )
plotWithAtoms( df_data, ilist, extent, dz = 0.1,  atoms=atoms );            savefig('df.png',     bbox_inches='tight', pad_inches=0 )
plotPositiveNegative( df_data, ilist, extent, dz = 0.1, atoms=atoms,  withcolorbar=True );            savefig('df_RB.png',     bbox_inches='tight', pad_inches=0 )

Fx,lvec, nDim, head = loadXSF('OutFx.xsf')
Fy,lvec, nDim, head = loadXSF('OutFy.xsf')
Fr = sqrt( Fx**2 + Fy**2 )
plotWithAtoms( Fr, ilist, extent, dz = 0.1,  atoms=atoms,  withcolorbar=True );            savefig('Fr.png',     bbox_inches='tight', pad_inches=0 )
plotDeviations_RG    ( Fx,Fy, ilist, extent,  atoms=atoms );                savefig('Fxy_RG.png',     bbox_inches='tight', pad_inches=0 )

show()
