#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os

# ========== Settings


#ilist =  [39,42,44,47]
#ilist =  [39,44,47]          # CO final
#ilist =  [40,43,45,48]

#ilist =  [34,36,38,40,42,44,46,48,50]   # Xe
#ilist =  [33,35,37,39,41,43,45,47,49]   # Xe

#ilist =  [5,10,15,20,25,30,35,40,45,50]

ilist =  [40,42,44,46,48,50]


bd    =  10 
shift =  6

cdict = {
'red':   ( (0.0, 0.0, 0.0),  (0.3333, 0.0, 0.0), (0.6666, 1.0, 1.0), (1.0, 1.0, 1.0)   ),
'green': ( (0.0, 0.0, 0.0),  (0.3333, 1.0, 1.0), (0.6666, 1.0, 1.0), (1.0, 1.0, 1.0)   ),
'blue':  ( (0.0, 0.0, 0.0),  (0.3333, 0.0, 0.0), (0.6666, 0.0, 0.0), (1.0, 1.0, 1.0)   )       
 }
cdict = {
'red':   ( (0.0, 0.0, 0.0),  (0.25, 0.0, 0.0), (0.50, 1.0, 1.0), (0.75, 1.0, 1.0), (1.0, 1.0, 1.0)   ),
'green': ( (0.0, 0.0, 0.0),  (0.25, 1.0, 1.0), (0.50, 1.0, 1.0), (0.75, 0.0, 0.0), (1.0, 1.0, 1.0)   ),
'blue':  ( (0.0, 0.0, 0.0),  (0.25, 0.0, 0.0), (0.75, 0.0, 0.0), (0.75, 0.0, 0.0), (1.0, 1.0, 1.0)   )       
 }
cdict = {
'red':   ( (0.0, 0.0, 0.0),  (0.2, 0.2, 0.2),  (1.0, 1.0, 1.0)   ),
'green': ( (0.0, 0.0, 0.0),  (0.2, 0.2, 0.2),  (1.0, 1.0, 1.0)   ),
'blue':  ( (0.0, 0.0, 0.0),  (0.2, 1.0, 1.0),  (1.0, 1.0, 1.0)   )       
 }
cmap= LinearSegmentedColormap('BlueRed1', cdict)

# =========== prepare everything

extent=( -shift, shift , -shift, shift  )

atoms = loadBas('surf.bas')[0]
#atoms = None
bonds = findBondsSimple(atoms, 1.7 ) 

# =========== Plot individaul datafiles


#if os.path.isfile('Ediff.xsf'):
if False:
	Ediff,lvec, nDim, head = loadXSF('Ediff.xsf')
else:
	Efix,lvec, nDim, head = loadXSF('3Dfixed/OutE.xsf')
	Efix -= Efix[0,nDim[1]/2,nDim[2]/2]
	Erlx,lvec, nDim, head = loadXSF('3Drelaxed/OutE.xsf')
	Erlx -= Erlx[0,nDim[1]/2,nDim[2]/2]
	Ediff = Erlx - Efix  
	plotPositiveNegative( Efix, ilist, extent, dz = 0.1, atoms=atoms,  withcolorbar=True , bd=bd);    savefig('Efix_RB.png',     bbox_inches='tight', pad_inches=0 )     
	plotPositiveNegative( Erlx, ilist, extent, dz = 0.1, atoms=atoms,  withcolorbar=True , bd=bd);    savefig('Erlx_RB.png',     bbox_inches='tight', pad_inches=0 )        
	saveXSF('Ediff.xsf', head, lvec, Ediff )

plotPositiveNegative( -Ediff, ilist, extent, dz = 0.1, atoms=atoms,  withcolorbar=True , bd=bd);            savefig('Ediff_RB.png',     bbox_inches='tight', pad_inches=0 )


show()
