#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap

# ========== Settings

yzoom = 1.25
#xlims = [7,12]
#xlims = [7,10]
xlims = [6.0,9]
ylims = [1,3.0]

flims  = [-0.15,0.20]
dflims = [-15,15] 

#vlines=[8.1,7.6,7.3] # CO k0.01
#vlines=[7.9,7.4,7.1] # CO k0.03
vlines=None # CO k0.03

lw = 1.5

# =========== functions

def k2e( k, Motal_Mass = 15.9994 ):
	hbar = 6.5821192815e-16      # eV.s ... reduced planck mass
	atomic_mass = 1.66053892e-27 # kg/atomic unit
	eVA2_to_Nm = 16.0217657
	f = sqrt( k * ( eVA2_to_Nm / ( atomic_mass * Motal_Mass ) )   ) 
	return 0.5*hbar*f*1000


def plotLines(F,xs,poss,lvec,nDim, bd=None, names=None, colors=None, xlims=None, ylims=None, vlines=None, hlines=None, yzoom=1, lw=1 ):
	Fmin = float("inf")
	linedata = zeros( (len(poss)+1,len(F)) )
	linedata[0,:] = xs
	for i in range(len(poss)):
		pos = poss[i]
		if names is not None:
			name=names[i]
		ix = int(round( nDim[1]*(pos[0]-lvec[0,0])/lvec[1,0]  ))
		iy = int(round( nDim[2]*(pos[1]-lvec[0,1])/lvec[2,1]  ))
		#print ix,iy
		Fline = F[:,iy,ix]
		if bd is None:
			Fmin = min(Fmin, Fline.min())
		else:
			Fmin = min(Fmin, Fline[bd:-bd].min())			
		#print shape(Fline),shape(xs)
		linedata[i+1,:] = Fline
		if colors is not None:
			plot(xs, Fline,   label=name, color=colors[i], lw=lw )
		else:
			plot(xs, Fline,   label=name, lw=lw )
	if hlines is not None:
		for xx in hlines:
			axhline(xx,ls='--',color='k')
	if vlines is not None:
		for xx in vlines:
			axvline(xx,ls='--',color='k')
	#legend()
	if ylims is None:
		ylim(Fmin*yzoom,-Fmin*yzoom)
	elif ylims == 'auto':
		pass
	else:
		ylim(ylims[0],ylims[1])	
	if xlim is not None:
		xlim(xlims[0],xlims[1])
	return linedata

def getPos( atoms, alist ):
	poss = []
	for i in alist:
		if isinstance( i, int ):
			a = [ atoms[1][i-1], atoms[2][i-1] ]
			poss.append( array( a ))
		else:
			a = array([ atoms[1][i[0]-1], atoms[2][i[0]-1] ])
			b = array([ atoms[1][i[1]-1], atoms[2][i[1]-1] ])
			poss.append( 0.5*(a+b) )
	return poss

# =========== prepare everything

shift = 11
extent=( -shift, shift , -shift, shift  )
atoms = loadBas('../surf.bas')[0]

#print atoms


#Cu2N
#shift =  6
#alist = [ 88,103, [87,103], [87,88] ]
#names = [ 'N', 'Cu', 'bond', 'void' ]
#colors = ['#00ee00','#ff0000','#ffee00','#000000' ]

#alist = [ 1,		5, 			[1,45],		 46,	[48,49], 	45,		[44,56],[46,47],	[1,5],	[50,51]	 ]
#names = [ 'Co', 	'NI', 		'Co-N',  	'C', 	'C-C', 	  'NP', 	'BKG', 		'P',	'CoNC',		'CR'  ]
#colors = ['#ff00ff','#0000ff','#00ff00','#000000','#808080','#0080ff','#008000','#800080','#ff8000','#000080' ]


#alist = [ 62,		56, 		[62,59],	31,	[32,33], 	59,		[70,71],[30,31],	[56,62],	[34,35]	 ]
#alist = [ 62,		57, 		[62,59],	31,	[32,33], 	59,		[70,71],[30,31],	[56,62],	[34,35]	 ]
#alist = [ 62,		57, 		[62,59],	31,	[32,33], 	59,		[70,71],[30,33],	[56,62],	[34,35]	 ]
#alist = [ 62,		57, 		[62,59],	31,	[32,33], 	59,		[70,71],[31,32],	[56,62],	[34,35]	 ]
#alist = [ 62,		57, 		[62,59],	31,	[32,33], 	59,		[70,71],[59,33],	[56,62],	[34,35]	 ]
#alist = [ 62,		57, 		[62,59],	31,	[32,33], 	59,		[70,71],[30,33],	[56,62],	[34,35]	 ]
#names = [ 'Co', 	'NI', 		'Co-N',  	'C', 	'C-C', 	  'NP', 	'BKG', 		'P',	'CoNC',		'CR'  ]
#colors = ['#ff00ff','#0000ff','#00ff00','#000000','#808080','#0080ff','#008000','#800080','#ff8000','#000080' ]

alist = [ 62,		56,57, 		[62,59],	31,	[32,33], 	59,		[70,71],[30,33],	[56,62],	[34,35]	 ]
names = [ 'Co', 	'NI56','NI57', 		'Co-N',  	'C', 	'C-C', 	  'NP', 	'BKG', 		'P',	'CoNC',		'CR'  ]
colors = ['#ff00ff','#0000ff','#0000ff','#00ff00','#000000','#808080','#0080ff','#008000','#800080','#ff8000','#000080' ]

#alist = [ 62,		  54,       55,       56,       57, 			 ]
#names = [ 'Co', 	'NI54',   'NI55',   'NI56',   'NI57',   ]
#colors = ['#ff00ff','#0000ff','#0080ff','#0000ff','#0080ff' ]

poss = getPos( atoms, alist )

poss[ 2 ]+=array([-0.1,0.1]) 

print "pos = ",poss


# =========== Plot individaul datafiles

figure(figsize=(5,5))
Eig1,lvec, nDim, head = loadXSF('OutEig1.xsf')

Eig1 = k2e( Eig1, Motal_Mass = 16 )

xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]
lvec[0,0] = -shift; lvec[0,1] = -shift 
linedata = plotLines(Eig1,xs,poss,lvec,nDim, names=names, colors=colors, xlims=xlims, lw=lw, hlines=[0], ylims=ylims, yzoom=yzoom )
savetxt( 'Eig1_1D.dat', transpose(linedata) )
savefig('Eig1_1D.png',     bbox_inches='tight', pad_inches=0 )

print "shape(linedata)", shape(linedata)

#linedataT = transpose(linedata)
#ixs = [ 40,45,50,55 ]
#ixs = [ 50,51,52,53,54,55,56 ]
#ixs = [ 52,54,56 ]
ixs = [ 53,54,55,56 ]
#ixs = [ 10,20,30 ]
figure(figsize=(10,5))
xxs = range(shape(linedata)[0]-1)
for i in range(len(ixs)):
	ix = ixs[i]
	line=linedata[1:,ix]
	plot( xxs, line, 'o:' )
xticks( xxs, names )
savefig('Eig_spot.png',     bbox_inches='tight', pad_inches=0 )

show()

