#!/usr/bin/env python

import numpy as np
from pylab import *
import csv
import sys

# directory in which I work
direc = str(sys.argv[1])

fig, (ax2 , ax3, ax1 ) = plt.subplots(nrows=3,ncols=1,figsize=(15,10), sharex=True)
fig.subplots_adjust( right=0.5 , hspace=0.003 )

axes = [ax1, ax1.twinx()]
axes1 = [ax2, ax2.twiny(), ax2.twinx()]
axes2 = [ax3]


#print "cas ",t
#####################################
# PLOT BOND DISTANCE
filename = str(direc)+'/dist-b.dat'
b = transpose( genfromtxt(filename, delimiter=",") )
#####################################
# CALCULATE AND PLOT VLOCITIES
db = ( b[1:] - b[:-1] )/(0.25)
#####################################
# PLOT d.V
dV_file = str(direc)+'/dV2-3.dat'
dV = ( genfromtxt(dV_file, delimiter=",") )
prob_file = str(direc)+'/prob3to2.dat'
prob = ( genfromtxt(prob_file, delimiter=",") )
#####################################
# PLOT EIGENVALUES DURING SIMULATION
filen = str(direc)+'/en.dat'
filesw = str(direc)+'/acceptsw.dat'
eig = genfromtxt(filen, delimiter=",")
labels=['1 HOMO-1','2 HOMO','3 LUMO','4 LUMO+1']
print "shape(eig)",shape(eig)
lab=0
snap=[25,77,95,147]

for i in range(6, 10):
	print lab
	axes1[1].plot(arange(len(eig))*0.25,eig[:,i],'-', lw=1, label=str(labels[lab]))
	if lab==0:
		axes1[0].plot([snap[0]-2], [eig[snap[0]/0.25,i]], 'k.', markersize=15.0)
		axes1[0].plot([snap[0]+2], [eig[snap[0]/0.25,i]], 'k.', markersize=15.0)

		axes1[0].plot([snap[1]-2], [eig[snap[1]/0.25,i]], 'k.', markersize=15.0)
		axes1[0].plot([snap[1]+2], [eig[snap[1]/0.25,i]], 'k.', markersize=15.0)

		axes1[0].plot([snap[2]-2], [eig[snap[2]/0.25,i]], 'k.', markersize=15.0)
		axes1[0].plot([snap[2]+2], [eig[snap[2]/0.25,i]], 'k.', markersize=15.0)

		axes1[0].plot([snap[3]-2], [eig[snap[3]/0.25,i]], 'k.', markersize=15.0)
		axes1[0].plot([snap[3]+2], [eig[snap[3]/0.25,i]], 'k.', markersize=15.0)
	if 0<lab<3:
		axes1[0].plot([snap[0]], [eig[snap[0]/0.25,i]], 'k.', markersize=15.0)
		axes1[0].plot([snap[1]], [eig[snap[1]/0.25,i]], 'k.', markersize=15.0)
		axes1[0].plot([snap[2]], [eig[snap[2]/0.25,i]], 'k.', markersize=15.0)
	if lab==1:
		axes1[0].plot([snap[3]-2], [eig[snap[3]/0.25,i]], 'k.', markersize=15.0)
		axes1[0].plot([snap[3]+2], [eig[snap[3]/0.25,i]], 'k.', markersize=15.0)
	lab=lab+1
axes1[0].set_yticks(arange(-8,1,1))
axes1[2].plot(arange(len(dV))*0.25,dV[:,0],'-', lw=1 , color='0.3' )

names = ['25 [fs]', '77 [fs]' , '95 [fs]' , ' \n 104.5 [fs] \n SWITCH','147 [fs]' ]
axes1[0].axvline(x=snap[0],ymin=-9,ymax=1,color='k')
axes1[0].axvline(x=snap[1],ymin=-9,ymax=1,color='k')
axes1[0].axvline(x=snap[2],ymin=-9,ymax=1,color='k')
axes1[0].axvline(x=snap[3],ymin=-9,ymax=1,color='k')

colors = ['k','r']
for n, tl in enumerate(axes1[1].xaxis.get_ticklabels()):
    tl.set_color(colors[n == 3])


axes1[0].axvline(x=418*0.25,ymin=-9,ymax=1,color='r')
axes[0].axvline(x=418*0.25,ymin=-9,ymax=1,color='r')
axes2[0].axvline(x=418*0.25,ymin=-9,ymax=1,color='r')

axes1[0].set_xticks(arange(0,201,25))
axes1[1].set_xticks([25,77,95,(418)*0.25+10,147])
axes1[1].set_xticklabels(names,rotation=45) #,fontsize=8)

axes1[1].legend(bbox_to_anchor=(0.65,1.02), loc=2)

# add switches lines to ax2
#ax2.set_xlabel('Time [fs]')
ax2.set_ylabel('Orbital energy [eV]')
#ax2.set_xlabel('Time[fs]')
u = genfromtxt(filesw,delimiter =",")
if len(shape(u))==1:
	u=array([u])    #[u] udela list a array udela numpy array
print "shape u: ",shape(u)
print u
#print sw1[0]
print "shape u", shape(u)
for l in arange(len(u)):
#print u[0,l]
	s=[u[l,0]*0.25,u[l,0]*0.25]
	ax2.set_xlim(0, 200)
	plt.text((u[l,0]*0.25-2.5), 22 , "%i" %u[l,1], ha='center',rotation=0, fontsize = 10, color='r' )
	plt.text((u[l,0]*0.25-2.5), 19   , "%i" %u[l,2], ha='center',rotation=0, fontsize = 10, color='r' )
##################################### TIME
# plot forces
#filfor = str(direc)+'/f-proj.dat'
filfor = str(direc)+'/fprj.dat'
f = genfromtxt(filfor)
print "shape f", shape(f)

filS0 = str(direc)+'/S0/ETOT.dat'
filS1 = str(direc)+'/S1/ETOT.dat'
filSocc = str(direc)+'/aux-ETOT.dat'
S0 = genfromtxt(filS0, delimiter=",")
S1 = genfromtxt(filS1, delimiter=",")
Socc = genfromtxt(filSocc, delimiter=",")

axes[0].plot(arange(len(b))*0.25,b,'-',color='r')
axes[0].set_ylabel('Position [$\AA$]', color='r')
axes[0].tick_params(axis='y', colors='r')
axes[0].set_ylim(1,5)
axes[0].set_yticks(arange(1,5,0.5))

axes2[0].plot(arange(len(S0))*0.25,S0,'-',color='k',linewidth=2.0,label='S0')
axes2[0].plot(arange(len(S1))*0.25,S1,'--',color='k',linewidth=2.0,label='S1')
axes2[0].plot(arange(len(Socc))*0.25,Socc,'ro',color='#66ddff',linewidth=2.0,markevery=20)
ax3.ticklabel_format(useOffset=False)
axes2[0].legend(bbox_to_anchor=(0.7,0.7), loc=2)

axes2[0].set_ylabel('Energyy [eV]', color='k')
axes2[0].set_xlim(0,200)
axes2[0].set_ylim(-2323,-2317)

axes[1].tick_params(axis='y', colors='g')
axes[1].set_xlim(0,200)
axes[1].plot([0,200],[0,0],'g--')
axes1[2].set_ylabel('v $\cdot$ g$_{32}$ [fs$^{-1}$]', color='0.3')
axes1[1].set_xlim(0,200)


axes[1].plot(arange(len(f))*0.25,f,'-',color='b')
#axes[2].plot(arange(len(prob))*0.25,prob,'-',color='b')
axes[1].set_ylabel('Force [eV/$\AA$]', color='b')
#axes[2].set_ylabel('prabability 3=>2 ', color='b')
axes[1].tick_params(axis='y', colors='b')
axes[1].set_xlim(0,200)
axes[1].plot([0,200],[0,0],'b--')

axes1[0].axvline(x=snap[0],ymin=-9,ymax=1,color='k')
axes1[0].axvline(x=snap[1],ymin=-9,ymax=1,color='k')
axes1[0].axvline(x=snap[2],ymin=-9,ymax=1,color='k')

axes1[0].axvline(x=921*0.25,ymin=-9,ymax=1,color='r')
axes[0].axvline(x=921*0.25,ymin=-9,ymax=1,color='r')
axes2[0].axvline(x=921*0.25,ymin=-9,ymax=1,color='r')
ax1.set_xlabel('Time[fs]')
ax1.set_xticks(arange(0,201,15))

#plt.show()
#fig.savefig("anhydride11-ETOT.png",dpi=500)
fig.savefig("anhydride11-ETOT.png")
#tight_layout()
#fig.savefig("mov"+str(a)+"myfig.png", bbox_inches='tight')

plt.show()
