#!/usr/bin/python

from xsfutil import *
from pylab import *
from STHM_Utils import *

from scipy import ndimage

# ============ setup

Eblur = 0.75

dz    = 0.1
bd    =  1
shift =  12.5

vmin = 1.0;  vmax = 4; 

#ilist =  [39,40,41,42,43,44,45,46,47,48,49,50]

#ilist =  [45,46,47,48,49,50,51,52,53,54,55,56]

#ilist =  [10,15,20,25,30,35,45,50]

ilist =  range(20,35)

#elist = [ 1.5,1.7,2.0 ]

elist = [ 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0 ]

extent=( -shift, shift , -shift, shift  )

cmap = 'jet'
withcolorbar = True




angle = -60

ix0  = 80
iy0  = 80
iszx = 200
iszy = 200



# ============ functions

def k2e( k, Motal_Mass = 15.9994 ):
	hbar = 6.5821192815e-16      # eV.s ... reduced planck mass
	atomic_mass = 1.66053892e-27 # kg/atomic unit
	eVA2_to_Nm = 16.0217657
	f = sqrt( k * ( eVA2_to_Nm / ( atomic_mass * Motal_Mass ) )   ) 
	return 0.5*hbar*f*1000


def Eslice( eigs, E, Eblur=1.0 ):
	dIdv2 = zeros(shape(eigs[0]))
	for eig in eigs:
		dIdv2 += exp( -(E - eig)**2/(Eblur**2) )
	return dIdv2

def rotData( data ):
	#print " shape(df_data) ",shape(data)
	#print " rotating ... "
	data = ndimage.rotate(data, angle, axes = (1,2))
	#print " shape(df_data) ",shape(df_data)
	#print "corping ... "
	data = data[:,ix0:ix0+iszx,iy0:iy0+iszy,]
	#print " shape(df_data) ",shape(df_data)
	return data

	
# ============= Main


Eig1,lvec, nDim, head   = loadXSF('OutEig1.xsf')
Eig2,lvec, nDim, head   = loadXSF('OutEig2.xsf')

Eig1 = k2e( Eig1, Motal_Mass = 16 )
Eig2 = k2e( Eig2, Motal_Mass = 16 )

print " Eig1[0,0,0] = ",Eig1[0,0,0]," [meV] "
print " Eig2[0,0,0] = ",Eig2[0,0,0]," [meV] "



Eig1 = rotData(Eig1)
Eig2 = rotData(Eig2)




plotWithAtoms( Eig1, ilist, extent, dz = 0.1, withcolorbar=withcolorbar, vmax=vmax, vmin=vmin, cmap='jet' );   savefig('Eig1.png',     bbox_inches='tight', pad_inches=0 )
plotWithAtoms( Eig2, ilist, extent, dz = 0.1, withcolorbar=withcolorbar, vmax=vmax, vmin=vmin, cmap='jet' );   savefig('Eig2.png',     bbox_inches='tight', pad_inches=0 )

print " Slicing dI^2/dV^2"
print " gaussian blur= ", Eblur
eigs = [ Eig1, Eig2 ]
for e in elist:
	print " Inelastic image for V=",e
	dIdV2 = Eslice( eigs, e, Eblur=Eblur )
	plotWithAtoms( dIdV2, ilist, extent);   savefig('Eig1_%3.3f.png' %e, bbox_inches='tight', pad_inches=0 )

	






	
