#!/usr/bin/python

from pylab import *
from xsfutil import *
from basUtils import *
import Element 

import sys


dz = 0.1       # [ Angstroem ]
k0 = 1800.0    # [ N/m ] 
f0 = 30300.0   # [ Hz  ]

df2K = 2.0*k0/f0 

def derivate( F  ):
	dim=shape(F)
	dF = zeros( (dim[0]-1,dim[1],dim[2]) )
	dF =  F[1:,:,:] - F[:-1,:,:]
	return dF

def DeSader( F ):
	dim=shape(F)
	dF = zeros( (dim[0]-3,dim[1],dim[2]) )
	print shape(  F )
	print shape( dF ) 
	dF[:,:,:] = ( -0.866*F[:-3,:,:] - 0.134*F[1:-2,:,:] + 0.134*F[2:-1,:,:] + 0.866*F[3:,:,:] )/2
	return dF

def smooth( F, n):
	for i in range(1):
		F[1:-1,:,:] = (F[2:,:,:] + 2*F[1:-1,:,:] +  F[:-2,:,:])/4  
	return F

# ======== code ==================


F,lvec, nDim, head = loadXSF('OutFz.xsf')

F  *= 16.0217656            # to N/m
dF = DeSader(F)/df2K/dz     # to [Hz]

saveXSF('df.xsf', head, lvec, dF )





