#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap

# ========== Settings

bd    =  30 
shift =  10

yzoom = 2
xlims = [7,12]

# =========== functions

def plotLines(F,xs,poss,lvec,nDim, bd=None, names=None, colors=None, xlims=None, yzoom=1 ):
	Fmin = float("inf")
	for i in range(len(poss)):
		pos = poss[i]
		if names is not None:
			name=names[i]
		ix = int(round( nDim[1]*(pos[0]-lvec[0,0])/lvec[1,0]  ))
		iy = int(round( nDim[2]*(pos[1]-lvec[0,1])/lvec[2,1]  ))
		#print ix,iy
		Fline = F[:,iy,ix]
		if bd is None:
			Fmin = min(Fmin, Fline.min())
		else:
			Fmin = min(Fmin, Fline[bd:-bd].min())			
		#print shape(Fline),shape(xs)
		if colors is not None:
			plot(xs, Fline,   label=name, color=colors[i] )
		else:
			plot(xs, Fline,   label=name )
	axhline(0,ls='--',color='k')
	legend()
	ylim(Fmin*yzoom,-Fmin*yzoom)
	if xlim is not None:
		xlim(xlims[0],xlims[1])

def getPos( atoms, alist ):
	poss = []
	for i in alist:
		if isinstance( i, int ):
			a = [ atoms[1][i-1], atoms[2][i-1] ]
			poss.append( array( a ))
		else:
			a = array([ atoms[1][i[0]-1], atoms[2][i[0]-1] ])
			b = array([ atoms[1][i[1]-1], atoms[2][i[1]-1] ])
			poss.append( 0.5*(a+b) )
	return poss

# =========== prepare everything

extent=( -shift, shift , -shift, shift  )
atoms = loadBas('../surf.bas')[0]

#print atoms


# for NCDI
#alist = [ [32,35], [32,38], [96,5],[14,5],[96,90] ]
#names = [ 'ring', 'Cbond', 'Hbond', 'void','Hvoid' ]
#colors = ['#ff0000','#00ee00','#0000ff','#ff00ff','#008080' ]

# for PTCDA Au111
alist = [ [163,158], [168,163], [189,106], [189,107], [106,143] ]
names = [ 'ring', 'Cbond', 'Hbond', 'Hvoid', 'void' ]
colors = ['#ff0000','#00ee00','#0000ff','#00C0C0','#ff00ff' ]




poss = getPos( atoms, alist )

print "pos = ",poss


# =========== Plot individaul datafiles

#Fz,lvec, nDim, head = loadXSF('OutFz.xsf')
Fz,lvec, nDim, head = loadXSF('OutE.xsf')
xs = 12.0 - array(range(nDim[0]))*lvec[3,2]/nDim[0]

figure(figsize=(5,5))
E,lvec, nDim, head = loadXSF('OutE.xsf')
E[:] = E[:] - E[0]
lvec[0,0] = -shift; lvec[0,1] = -shift 
plotLines(E,xs,poss,lvec,nDim, names=names, colors=colors)
savefig('E1D.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
Fz,lvec, nDim, head = loadXSF('OutFz.xsf')
lvec[0,0] = -shift; lvec[0,1] = -shift 
plotLines(Fz,xs,poss,lvec,nDim, names=names, colors=colors)
savefig('Fz1D.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
dFz = F2df( Fz, dz = 0.1, k0 = 1800.0, f0=30300.0 )
print shape(dFz),shape(xs)
xsdf =  0.5*(xs[2:-1]+xs[1:-2])
plotLines(dFz,xsdf,poss,lvec,nDim,bd=10, names=names, colors=colors, yzoom=2, xlims=zlims )
savefig('df1D.png',     bbox_inches='tight', pad_inches=0 )

show()

