#!/usr/bin/python

from pylab import *

Efix = transpose(genfromtxt('fix_1D_E.dat'))
Erlx = transpose(genfromtxt(    '1D_E.dat'))
Ffix = transpose(genfromtxt('fix_1D_F.dat'))
Frlx = transpose(genfromtxt(    '1D_F.dat'))

xs = Efix[0]

subplot(1,2,1)
plot(xs, Efix[1],label='fixed')
plot(xs, Erlx[1],label='relaxed')
xlabel(' z [$\AA$] ')
ylabel(' Energy [eV] ')
ylim( Erlx[1].min()*1.2 ,  Erlx[1].max()*1.1)


subplot(1,2,2)
plot(xs, Ffix[3]*1.60217657, label='fixed')
plot(xs, Frlx[3]*1.60217657, label='relaxed')
xlabel(' z [$\AA$] ')
ylabel(' Force [nN] ')
ylim( Frlx[3].min()*1.60217657, Frlx[3].max()*1.60217657    )
axhline(0)

show()

