#!/usr/bin/python

from pylab import *

Es  = transpose(genfromtxt('m1D_E.dat'))
Fzs = transpose(genfromtxt('m1D_Fz.dat'))

#print "Es[1,-1]",Es[1]
E0 = Es[1,0]
print "E0",E0
xs = Fzs[0]

Emin = 1000000
Fmin = 1000000
for i in range(2,len(Es)):
	E = Es[i]-E0; Emin=min(Emin,E.min())
	subplot(1,2,1); plot(xs, E);
	#F = Fzs[i]*1.60217657; Fmin = min(Fmin,F.min()) 
	F = (Fzs[i]+Fzs[1])*1.60217657; Fmin = min(Fmin,F.min()) 
	subplot(1,2,2); plot(xs, F )

subplot(1,2,1)
#xlabel(' z [$\AA$] ')
#ylabel(' Energy [eV] ')
title('Energy [eV]')
ylim( Emin*1.2 ,  -Emin*1.2)

subplot(1,2,2)
#xlabel(' z [$\AA$] ')
#ylabel(' Force [nN] ')
ylim( Fmin*1.2 ,  -Fmin*1.2   )
title('Force [nN]')
axhline(0)

savefig('plot1Dpos.png', bbox_inches='tight', pad_inches=0 )

show()

