#!/usr/bin/python

from pylab import *
import sys

# ================== Input

k0 = 1800.0    # [ N/m ] 
f0 = 30300.0   # [ Hz  ]
df2K = 2.0*k0/f0 # [ (N/m) / Hz ]


Fadd=0;Kadd=0;
if (len(sys.argv)==2):
	if ( sys.argv[1]=='CO' ):
		Fadd =  -0.020  - 0.011  # [ nN             ] 
		Kadd =  -0.018  - 0.007  # [ nN / Angstrome ] 
		xshift = 6.4
		Fmin   = -0.15
		dfmin  = -1.0
	if ( sys.argv[1]=='COmod' ):
		Fadd =  -0.020  - 0.011  # [ nN             ] 
		Kadd =  -0.018  - 0.002  # [ nN / Angstrome ] 
		xshift = 6.0
		Fmin   = -0.12
		dfmin  = -0.6
	if ( sys.argv[1]=='Xe' ):
		Fadd =  -0.027 - 0.01   # [ nN             ] 
		Kadd =  -0.018          # [ nN / Angstrome ] 
		xshift = 6.9
		Fmin   = -0.35
		dfmin  = -3.0

# ================== Functions

def DeSader( F ):
	dim=shape(F)
	dF = zeros( dim[0]-3 )
	#print shape(  F )
	#print shape( dF ) 
	dF[:] = ( -0.866*F[:-3] - 0.134*F[1:-2] + 0.134*F[2:-1] + 0.866*F[3:] )/2
	#dF[:] = ( -F[1:-2] + F[2:-1] )
	return dF

def loadAndPlotSim(name, clr=None,  i=5 ):
	dataF = transpose(genfromtxt( name+'/m1D_Fz.dat', skip_header=1 ))
	xs = dataF[0]; dz = -(xs[1]-xs[0])
	print " sim dz = ",dz
	F  = (dataF[2+i]+dataF[1])*1.60217657
	dF = DeSader(F)/df2K/dz  
	if clr is not None: 
		subplot(121);  plot(xs      , F  ,'-', color=clr, label=name+'Sim')
		subplot(122);  plot(xs[1:-2], dF ,'-', color=clr, label=name+'Sim')
	else:
		subplot(121);  plot(xs      , F  ,'-', label=name+'Sim')
		subplot(122);  plot(xs[1:-2], dF ,'-', label=name+'Sim')

def loadAndPlotExp(name, simData=None , xshift=0, clr=None, Fadd=-0.0205, Kadd=-0.018  ):
	data = transpose(genfromtxt( 'F_'+name+'.dat', skip_header=1 ))
	xs = data[1];  dz = xs[1]-xs[0]
	print " exp dz = ",dz
	F  = data[2]*1e+9
	F2 = F + Fadd - Kadd*(xs[0]-xs)
	dF  = DeSader(F)/df2K/dz
	dF2 = DeSader(F2)/df2K/dz
	xs =  xs[-1] - xs
	xs  = xs + xshift
	#F  += Fshift
	#print shape(xs[1:-2]),shape(dF)
	if clr is not None:
		#subplot(121);  plot(xs      ,  F,  '.-', color=clr, label=name+'Exp')
		subplot(121);  plot(xs      ,  F2, '.-', color=clr,alpha=1.0, label=name+'Exp lin')
		#subplot(122);  plot(xs[1:-2], dF , '.-', color=clr, label=name+'Exp')
		subplot(122);  plot(xs[1:-2], dF2, '.-', color=clr, alpha=1.0, label=name+'Exp lin')
	else:
		subplot(121);  plot(xs      ,  F, '.-', label=name+'Exp')
		subplot(122);  plot(xs[1:-2], dF, '.-', label=name+'Exp')

# ================== Main

loadAndPlotSim('ring', clr='#FF0000')
loadAndPlotExp('ring', clr='#FF0000',     Fadd=Fadd, Kadd=Kadd, xshift=xshift  )

loadAndPlotSim('atom', clr='#0000FF' )
loadAndPlotExp('atom', clr='#0000FF', Fadd=Fadd, Kadd=Kadd,  xshift=xshift )

#Fmin  = ringSimData[1].min()

subplot(121); axhline( 0.0 ,linestyle ='--', color='k'); title( "F$_z$  [nN] "    );  ylim(Fmin*1.0,-Fmin*0.5);   #  legend();
subplot(122); axhline( 0.0 ,linestyle ='--', color='k'); title( "dF [Hz] " );  ylim( dfmin*1.0,-dfmin*0.5 );   # legend();    

savefig('AtomRing1D.png', bbox_inches='tight', pad_inches=0 )

show()
