#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap

# ========== Settings

ilist =  [40,41,42,43,44,45,46,47,48,49,50]
#ilist =  [35,36,37,38,39,40,41,42,43,44,45]
n=len(ilist)

bd    =  30
shift =  7

extent=( -shift, shift , -shift, shift  )
atoms = loadBas('surf.bas')[0]

vmax=50
vmin=-5

# =========== ColorMap

cdict = {
'red':   ( (0.0, 0.0, 0.0),  (0.2, 0.2, 0.2),  (1.0, 1.0, 1.0)   ),
'green': ( (0.0, 0.0, 0.0),  (0.2, 0.2, 0.2),  (1.0, 1.0, 1.0)   ),
'blue':  ( (0.0, 0.0, 0.0),  (0.2, 1.0, 1.0),  (1.0, 1.0, 1.0)   )       
 }
cmap= LinearSegmentedColormap('BlueRed1', cdict)
#cmap='gray'

# =========== Main

Frlx,lvec, nDim, head = loadXSF('3Drelaxed/OutFz.xsf')
dFrlx = F2df( Frlx, dz = 0.1, k0 = 1800.0, f0=30300.0 )
plotWithAtoms( dFrlx[:,bd:-bd,bd:-bd], ilist, extent, dz = 0.1,  atoms=atoms, cmap=cmap, vmin=vmin, vmax=vmax  );           
#plotWithAtoms( dFrlx, ilist, extent, dz = 0.1,  atoms=atoms, cmap=cmap, vmin=vmin, vmax=vmax )    
savefig('dFrlx.png',     bbox_inches='tight', pad_inches=0 )

Ffix,lvec, nDim, head = loadXSF('3Dfixed/OutFz.xsf')
dFfix = F2df( Ffix, dz = 0.1, k0 = 1800.0, f0=30300.0 )
plotWithAtoms( dFfix[:,bd:-bd,bd:-bd], ilist, extent, dz = 0.1,  atoms=atoms, cmap=cmap, vmin=vmin, vmax=vmax  );            
#plotWithAtoms( dFfix, ilist, extent, dz = 0.1, atoms=atoms, cmap=cmap, vmin=vmin, vmax=vmax )    
     
savefig('dFfix.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
Xs,Ys = meshgrid(arange(-1,1,0.01),arange(-1,1,0.01))
imshow(sin(Xs)*sin(Ys), vmin=vmin, vmax=vmax, cmap=cmap)
colorbar()
savefig('colorbar.png',     bbox_inches='tight', pad_inches=0 ) 


show()

