#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap

# ========== Settings

#ilist =  [0,40,45,50,55]
#ilist =  [40,42,44,46,48,50]
#ilist =  [40,41,42,43,44,45,46,47,48,49,50] # CO
ilist =  [39,44,47]          # CO final
#ilist =  [35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50]
#ilist =  [5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80]
#ilist =  [45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60]
#ilist =  [50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70]

bd    =  30 
shift =  7


# =========== prepare everything

extent=( -shift, shift , -shift, shift  )

atoms = loadBas('../surf.bas')[0]
bonds = findBondsSimple(atoms, 1.7 ) 

withcolorbar = False


# =========== Plot individaul datafiles


T1,lvec, nDim, head = loadXSF('OutT1.xsf')
T2,lvec, nDim, head = loadXSF('OutT2.xsf')
TSS1,lvec, nDim, head = loadXSF('OutTSS1.xsf')
TSS2,lvec, nDim, head = loadXSF('OutTSS2.xsf')
R1,lvec, nDim, head = loadXSF('OutR1.xsf')

plotWithAtoms( T1, ilist, extent, dz = 0.1,   atoms=atoms,  withcolorbar=withcolorbar );      savefig('T1.png',     bbox_inches='tight', pad_inches=0 )
plotWithAtoms( T2, ilist, extent, dz = 0.1,   atoms=atoms,  withcolorbar=withcolorbar);       savefig('T2.png',     bbox_inches='tight', pad_inches=0 )
plotWithAtoms( TSS1, ilist, extent, dz = 0.1, atoms=atoms,  withcolorbar=withcolorbar );      savefig('TSS1.png',     bbox_inches='tight', pad_inches=0 )
plotWithAtoms( TSS2, ilist, extent, dz = 0.1, atoms=atoms,  withcolorbar=withcolorbar);       savefig('TSS2.png',     bbox_inches='tight', pad_inches=0 )
plotWithAtoms( R1, ilist, extent, dz = 0.1,   atoms=atoms,  withcolorbar=withcolorbar );      savefig('R1.png',     bbox_inches='tight', pad_inches=0 )

atoms = None
withcolorbar = True

plotWithAtoms( T1, ilist, extent, dz = 0.1,   atoms=atoms,  withcolorbar=withcolorbar );      savefig('T1_cbar.png',     bbox_inches='tight', pad_inches=0 )
plotWithAtoms( T2, ilist, extent, dz = 0.1,   atoms=atoms,  withcolorbar=withcolorbar);       savefig('T2_cbar.png',     bbox_inches='tight', pad_inches=0 )
plotWithAtoms( TSS1, ilist, extent, dz = 0.1, atoms=atoms,  withcolorbar=withcolorbar );      savefig('TSS1_cbar.png',     bbox_inches='tight', pad_inches=0 )
plotWithAtoms( TSS2, ilist, extent, dz = 0.1, atoms=atoms,  withcolorbar=withcolorbar);       savefig('TSS2_cbar.png',     bbox_inches='tight', pad_inches=0 )
plotWithAtoms( R1, ilist, extent, dz = 0.1,   atoms=atoms,  withcolorbar=withcolorbar );      savefig('R1_cbar.png',     bbox_inches='tight', pad_inches=0 )

#show()
