#!/usr/bin/python

from pylab import *
from xsfutil import *
from basUtils import *
import Element 

# =============== setup

#         x1   x2   y1    y2
extent=( -10.0 , 10.0, -10.0 , 10.0 ) #  2D data extend real space of atoms [Angstroem]

cmap = 'jet'	# color map
#cmap = 'gray'
atomsize = 30.0


# ============== Functions

# function for plotting bonds
def plotBonds( xyz, bonds ):
	for b in bonds:
		i=b[0]; j=b[1]
		arrow(xyz[1][i], xyz[2][i], xyz[1][j]-xyz[1][i], xyz[2][j]-xyz[2][i], head_width=0.0, head_length=0.0,  fc='k', ec='k', lw= 1.0,ls='solid' )

# ============== Script main body 

atoms = loadBas('surf.bas')[0]			# load position of atoms
bonds = findBondsSimple(atoms, 1.7 ) 	# generate bonds

# This you don't need, I use it to generate the xy data plane from 3D xsf
#F,lvec, nDim, head = loadXSF('OutFx.xsf')	# load 3D data array from *.xsf
#Fslice = F[50]								# take 50-th slice in z
#Fslice[-100:,-100:] = nan					# set part of image to NaN (no-a-number, not defined)
#savetxt('Fslice.dat',Fslice)

Fslice = genfromtxt('Fslice.dat')	# load 2D data from data file

figure( figsize=(5,5 ) ) 			# set size of figure

imshow( Fslice,  extent=extent,  origin='image', interpolation='bicubic', cmap=cmap )	 # plot the 2D data,  NaN are plotted as white
plotBonds( atoms, bonds )												 # plot bonds as lines
scatter( atoms[1], atoms[2], s=array(atoms[0])*atomsize, c='#FFFFFF'  )  # plot atoms as circles using scatter plot
#xlim(extent[0],extent[1]); ylim(extent[2],extent[3])					 # set image range
#savefig( 'OutFx_all.png', bbox_inches='tight', pad_inches=0)			 # save figure to file

show()	# show everything on screen




