#!/usr/bin/python

from STHM_Utils import *
from xsfutil import *
from basUtils import *
from pylab import *
import sys,os
from matplotlib.colors import LinearSegmentedColormap
import matplotlib.colors as mcolors
import matplotlib.cm as cmx

# ========== Settings

bd    =  10
shift =  8

#ilist = [ 40,42,44,46,48,50  ]
#ilist = [ 40,41,42,43,44,45,46  ]
#xslice = 4.0

#ilist = [ 35,36,37,38,39,40,41,42,43,44,45,46  ]

#ilist = [ 35,36,37,38,39,40,41,42,43,44,45  ]

#ilist  = [ 35,36,37,38,39,40,41,42,43 ]
#ilist  = range(40,50)
ilist = [47]

#ilist = [ 36,38,40,42,44,46  ]

xslice = 0.0

yzoom = 1.5
xlims = [-1.5,1.5]

lw = 1.5

# =========== functions

def makeColorSeq( ilist, cmap='jet' ):
	cm = plt.get_cmap(cmap) 
	cNorm  = mcolors.Normalize( vmin=ilist[0], vmax=ilist[-1] )
	scalarMap = cmx.ScalarMappable(norm=cNorm, cmap=cm)
	colors = []
	for i in range(len(ilist)):
		colors.append( scalarMap.to_rgba(ilist[i]) )
	return colors

def plotLineProfilesYcomp(F1, F2,yslice,ilist,lvec,nDim, bd=None, colors=None, xlims=None, ylims=None, yzoom=1, lw=1, withlegend = False ):
	xs = array(range(nDim[1] ))*lvec[2,1]/nDim[1] + lvec[0,1]
	xs = xs[::-1]
	for i in range(len(ilist)):
		iz = ilist[i]
		iy = int(round( nDim[2]*(yslice-lvec[0,0])/lvec[1,0]  ))
		Fline1 = F1[iz,iy,:]
		Fline2 = F2[iz,iy,:]
		#if bd is None:
		#	Fmin = min(Fmin, Fline.min())
		#else:
		#	Fmin = min(Fmin, Fline[bd:-bd].min())			
		#print shape(Fline),shape(xs)
		dz=0.1
		#label="%1.1f$\AA$" %( 7.7 - iz*dz  )
		label="%1.1f$\AA$" %( iz*dz  )
		if colors is not None:
			plot(xs, Fline1,   label=label, color=colors[i], lw=lw,  ls='-')
			plot(xs, Fline2,                color=colors[i], lw=lw, ls='--' )
		else:
			plot(xs, Fline1,   label=label, lw=lw, ls='-' )
			plot(xs, Fline2,   label=label, lw=lw, ls='--' )
	axhline(0,ls='--',color='k')
	if withlegend:
		legend()
	if ylims is not None:
		ylim(ylims[0],ylims[1])
	if xlims is not None:
		xlim(xlims[0],xlims[1])


# =========== prepare everything

extent=( -shift, shift , -shift, shift  )
atoms = loadBas('surf.bas')[0]

colors = makeColorSeq( ilist )

print colors


# =========== Plot individaul datafiles

figure(figsize=(5,5))
E1,lvec, nDim, head = loadXSF('3Drelaxed-k0.03/OutE.xsf')
E2,lvec, nDim, head = loadXSF('3Dfixed/OutE.xsf')
E1 = transpose(E1,(0,2,1) )
E2 = transpose(E2,(0,2,1) )
E1[:] = E1[:] - E1[0]
E2[:] = E2[:] - E2[0]
lvec[0,0] = -shift; lvec[0,1] = -shift 
plotLineProfilesYcomp(E1,E2,xslice,ilist,lvec,nDim, colors=colors, yzoom=yzoom, lw=lw, xlims=xlims, ylims=[-0.055,-0.045]  )  # ylims=[-0.045,-0.040] 
savefig('E_lineProfiles_comp.png',     bbox_inches='tight', pad_inches=0 )
legend()
savefig('E_lineProfiles_legend_comp.png',     bbox_inches='tight', pad_inches=0 )

figure(figsize=(5,5))
Fz1,lvec, nDim, head = loadXSF('3Drelaxed-k0.03/OutFz.xsf')
Fz2,lvec, nDim, head = loadXSF('3Dfixed/OutFz.xsf')
Fz1 = transpose(Fz1,(0,2,1) )
Fz2 = transpose(Fz2,(0,2,1) )
lvec[0,0] = -shift; lvec[0,1] = -shift 
plotLineProfilesYcomp(Fz1*1.60217657,Fz2*1.60217657,xslice,ilist,lvec,nDim, colors=colors, yzoom=yzoom, lw=lw, xlims=xlims )
savefig('Fz_lineProfiles_comp.png',     bbox_inches='tight', pad_inches=0 )


figure(figsize=(5,5))
dFz1 = F2df( Fz1, dz = 0.1, k0 = 1800.0, f0=30300.0 )
dFz2 = F2df( Fz2, dz = 0.1, k0 = 1800.0, f0=30300.0 )
plotLineProfilesYcomp(dFz1,dFz2,xslice,ilist,lvec,nDim, colors=colors, yzoom=yzoom, lw=lw, xlims=xlims )
savefig('df_lineProfiles_comp.png',     bbox_inches='tight', pad_inches=0 )

show()


