#!/usr/bin/python

from pylab import *
from xsfutil import *
from basUtils import *
from matplotlib.colors import LinearSegmentedColormap
import Element 

import sys

#cmap = 'jet'
dz = 0.1



#fnames = ['OutE','OutFx','OutFy','OutFz','OutX','OutY','OutZ']

#fnames = ['OutE','OutFz','OutX','OutY','df']

fnames = ['OutFzTip','OutFz']

#fnames = ['OutY']
#ilist = [0,3,5,7, 10,13,15,17, 20,23,25, 27, 30, 33, 35,37, 40,43,45,47, 50,53,55,57]
ilist = [ 20,23,25, 27, 30, 33, 35,37, 40,43,45,47, 50,53,55,57]

#ilist = [ 20,23,25, 27, 30, 33, 35,37, 40,43,45,47, 50,53,55,57]


#ilist = [ 40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55]
#ilist = [ 34,36,38,40,42,44,46,48]


#ilist =  [40,45,50,55]
n=len(ilist)

#vgreens=[ 0.3, 0.4, 0.5, 0.6 ] 
vgreens=[ 0.0 ] 

for fname in fnames:
	F,lvec, nDim, head = loadXSF(fname+'.xsf')
	print " lvec ",lvec
	print " nDim ",nDim
	print " dz ", dz
	# if there is not x0 in xsf
	lvec[0,0] += -10
	lvec[0,1] += -10
	n=len(ilist)
	#figure( figsize=(25,2+(25.0/n) ) );
	figure( figsize=(3*n,0.5+3 ) );
	#xyz = loadBas('../surf.bas')[0]
	xyz = loadBas('surf.bas')[0]
	for vgreen in vgreens:
		cdict2 = {	'red':   ( (0.0, 0.0, 0.0),  (vgreen, 0.0, 0.0), (1.0, 1.0, 1.0)   ),
					'green': ( (0.0, 0.0, 0.0),  (vgreen, 1.0, 0.0), (1.0, 1.0, 1.0)   ),
					'blue':  ( (0.0, 0.0, 0.0),  (vgreen, 0.0, 0.0), (1.0, 1.0, 1.0)   )    }
		cmap= LinearSegmentedColormap('BlueRed1', cdict2)
		for i in range(n):
			ii = ilist[i]
			vmax=F[ii,5:-5,5:-5].max()
			vmin=F[ii,5:-5,5:-5].min()
			print " i,vmin,vmax ",i,vmin,vmax
			subplot(1,n,i+1);
			title( "z=%2.2f$\AA$" %(dz*ii)  );
			extent=( lvec[0,0], lvec[1,0]+lvec[0,0] ,   lvec[0,1],    lvec[2,1]+lvec[0,1]  )
			#print "extent=",extent
			#imshow( F[ii],  extent=extent,  origin='image', interpolation='nearest', cmap=cmap, vmin=vmin, vmax=vmax ) 
			imshow( F[ii],  extent=extent,  origin='image', interpolation='bicubic', cmap=cmap, vmin=vmin, vmax=vmax ) 
			#if( i==(n-1) ):
			#	colorbar()
			#xyz = loadBas('surf.bas')[0]
			scatter( xyz[1], xyz[2], s=sqrt(xyz[0])*10,   c='#FFFFFF'  )
			xlim(extent[0],extent[1])
			ylim(extent[2],extent[3])
		savefig( fname+'_all_green2_%0.2f.png' %vgreen, bbox_inches='tight', pad_inches=0)

#show();




